/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.alternatemix;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.tools.alternatemix.AlternateMixParametersBuilder;
import org.pdfsam.ui.components.selection.multiple.FileColumn;
import org.pdfsam.ui.components.selection.multiple.IntColumn;
import org.pdfsam.ui.components.selection.multiple.LoadingColumn;
import org.pdfsam.ui.components.selection.multiple.LongColumn;
import org.pdfsam.ui.components.selection.multiple.MultipleSelectionPane;
import org.pdfsam.ui.components.selection.multiple.PaceColumn;
import org.pdfsam.ui.components.selection.multiple.PageRangesColumn;
import org.pdfsam.ui.components.selection.multiple.ReverseColumn;
import org.pdfsam.ui.components.selection.multiple.SelectedPagesColumn;
import org.pdfsam.ui.components.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.components.selection.multiple.TableColumnProvider;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.input.PdfSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternateMixSelectionPane
extends MultipleSelectionPane
implements TaskParametersBuildStep<AlternateMixParametersBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(AlternateMixSelectionPane.class);

    public AlternateMixSelectionPane(String ownerModule) {
        super(ownerModule, true, true, new TableColumnProvider[]{new LoadingColumn(ownerModule), FileColumn.NAME, LongColumn.SIZE, IntColumn.PAGES, new PageRangesColumn(I18nContext.i18n().tr("Double click to set pages you want to mix (ex: 2 or 5-23 or 2,5-7,12-)")), new SelectedPagesColumn(), new PaceColumn(), new ReverseColumn(), LongColumn.LAST_MODIFIED});
        this.showTotalPagesLabel();
    }

    public void apply(AlternateMixParametersBuilder builder, Consumer<String> onError) {
        block5: {
            try {
                List<SelectionTableRowData> inputs = this.table().getItems().stream().filter(s -> !Objects.equals("0", StringUtils.trim((String)s.pageSelection.get()))).toList();
                if (inputs.isEmpty()) {
                    onError.accept(I18nContext.i18n().tr("No PDF document has been selected"));
                    break block5;
                }
                for (SelectionTableRowData row : inputs) {
                    String step = ((String)StringUtils.defaultIfBlank((CharSequence)row.pace.get(), (CharSequence)"1")).trim();
                    if (step.matches("[1-9]\\d*")) {
                        PdfMixInput input = new PdfMixInput((PdfSource)row.descriptor().toPdfFileSource(), row.reverse.get(), Integer.parseInt(step));
                        input.addAllPageRanges((Collection)row.toPageRangeSet());
                        builder.addInput(input);
                        continue;
                    }
                    onError.accept(I18nContext.i18n().tr("Select a positive integer number as pace"));
                    break;
                }
            }
            catch (ConversionException e) {
                LOG.error(e.getMessage());
                onError.accept(e.getMessage());
            }
        }
    }
}

