/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.news;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pdfsam.core.AppBrand;
import org.pdfsam.core.BrandableProperty;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.news.NewsData;
import org.pdfsam.persistence.PersistenceException;
import org.pdfsam.persistence.PreferencesRepository;
import org.pdfsam.service.news.NewsService;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNewsService
implements NewsService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNewsService.class);
    static final String LATEST_NEWS_ID = "latest.news.id";
    static final String LATEST_IMPORTANT_NEWS_ID = "latest.important.news.id";
    private final PreferencesRepository repo;
    private final AppBrand appBrand;
    private final ObjectMapper mapper;

    @Inject
    DefaultNewsService(AppBrand appBrand, ObjectMapper mapper, @Named(value="newsRepository") PreferencesRepository repo) {
        RequireUtils.requireNotNullArg((Object)appBrand, (String)"Application info cannot be null");
        this.appBrand = appBrand;
        this.mapper = mapper;
        this.repo = repo;
    }

    @Override
    public List<NewsData> getLatestNews() {
        try {
            return Arrays.asList((NewsData[])this.mapper.readValue(new URL(this.appBrand.property(BrandableProperty.NEWS_URL)), NewsData[].class));
        }
        catch (IOException e) {
            LOG.warn(I18nContext.i18n().tr("Unable to retrieve latest news"), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public int getLatestNewsSeen() {
        return this.repo.getInt(LATEST_NEWS_ID, -1);
    }

    @Override
    public void setLatestNewsSeen(int id) {
        try {
            this.repo.saveInt(LATEST_NEWS_ID, id);
            LOG.trace("Latest news id stored");
        }
        catch (PersistenceException e) {
            LOG.error("Unable to store the id of the most recently seen news");
        }
    }

    @Override
    public int getLatestImportantNewsSeen() {
        return this.repo.getInt(LATEST_IMPORTANT_NEWS_ID, -1);
    }

    @Override
    public void setLatestImportantNewsSeen(int id) {
        try {
            this.repo.saveInt(LATEST_IMPORTANT_NEWS_ID, id);
            LOG.trace("Latest important news id stored");
        }
        catch (PersistenceException e) {
            LOG.error("Unable to store the id of the most recently seen important news");
        }
    }

    @Override
    public void clear() {
        try {
            this.repo.clean();
        }
        catch (PersistenceException e) {
            LOG.error("Unable to clear latest news store", (Throwable)e);
        }
    }
}

