/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.pdf;

import java.util.Optional;
import org.apache.commons.lang3.time.FastDateFormat;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.tool.RequiredPdfData;
import org.pdfsam.service.pdf.PdfLoader;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentInformation;

public class DefaultSAMBoxLoader
implements PdfLoader<PDDocument> {
    private static final FastDateFormat FORMATTER = FastDateFormat.getDateTimeInstance((int)0, (int)2);

    @Override
    public void accept(PDDocument document, PdfDocumentDescriptor descriptor) {
        descriptor.pages(document.getNumberOfPages());
        descriptor.setVersion(this.getVersion(document.getVersion()));
        PDDocumentInformation info = document.getDocumentInformation();
        descriptor.putInformation("Title", info.getTitle());
        descriptor.putInformation("Author", info.getAuthor());
        descriptor.putInformation("Creator", info.getCreator());
        descriptor.putInformation("Subject", info.getSubject());
        descriptor.putInformation("Keywords", info.getKeywords());
        descriptor.putInformation("Producer", info.getProducer());
        Optional.ofNullable(info.getCreationDate()).map(arg_0 -> ((FastDateFormat)FORMATTER).format(arg_0)).ifPresent(c -> descriptor.putInformation("FormattedCreationDate", c));
    }

    @Override
    public RequiredPdfData key() {
        return RequiredPdfData.DEFAULT;
    }

    private PdfVersion getVersion(String version) {
        for (PdfVersion current : PdfVersion.values()) {
            if (!current.getVersionString().equals(version)) continue;
            return current;
        }
        return null;
    }
}

