/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.premium;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pdfsam.core.AppBrand;
import org.pdfsam.core.BrandableProperty;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.premium.PremiumTool;
import org.pdfsam.service.premium.PremiumToolsService;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPremiumToolsService
implements PremiumToolsService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPremiumToolsService.class);
    private final AppBrand appBrand;
    private final ObjectMapper mapper;

    @Inject
    DefaultPremiumToolsService(AppBrand appBrand, ObjectMapper mapper) {
        RequireUtils.requireNotNullArg((Object)appBrand, (String)"Application info cannot be null");
        this.appBrand = appBrand;
        this.mapper = mapper;
    }

    @Override
    public List<PremiumTool> getPremiumTools() {
        try {
            return Arrays.asList((PremiumTool[])this.mapper.readValue(new URL(this.appBrand.property(BrandableProperty.PREMIUM_TOOLS_URL)), PremiumTool[].class));
        }
        catch (IOException e) {
            LOG.warn(I18nContext.i18n().tr("Unable to retrieve premium features description"), (Throwable)e);
            return Collections.emptyList();
        }
    }
}

