/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.support.params.SingleOutputTaskParametersBuilder;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.io.OpenType;
import org.pdfsam.ui.components.io.BrowsableFileField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.sejda.model.output.FileTaskOutput;

public class BrowsablePdfOutputField
extends BrowsableFileField
implements TaskParametersBuildStep<SingleOutputTaskParametersBuilder<?>> {
    public BrowsablePdfOutputField() {
        super(FileType.PDF, OpenType.SAVE);
        this.enforceValidation(false, false);
    }

    public void apply(SingleOutputTaskParametersBuilder<?> builder, Consumer<String> onError) {
        Path path;
        String output = this.getTextField().getText();
        if (StringUtils.isNotBlank((CharSequence)output) && !(path = Paths.get(output, new String[0])).isAbsolute()) {
            this.getTextField().setText(ApplicationContext.app().runtimeState().workingPathValue().map(w -> w.resolve(output)).orElse(path).toString());
        }
        this.getTextField().validate();
        if (this.getTextField().getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.output(new FileTaskOutput(new File(this.getTextField().getText())));
        } else {
            onError.accept(I18nContext.i18n().tr("A .pdf destination file extension is required"));
        }
    }
}

