/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.model.ui.AddPdfVersionConstraintEvent;
import org.pdfsam.model.ui.RemovePdfVersionConstraintEvent;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.commons.util.RequireUtils;
import org.sejda.model.pdf.PdfVersion;

class PdfVersionConstrainedCheckBox
extends CheckBox
implements ToolBound {
    private final PdfVersion constraint;
    private String toolBinding = "";

    public PdfVersionConstrainedCheckBox(PdfVersion constraint, String toolBinding) {
        RequireUtils.requireNotNullArg((Object)constraint, (String)"PdfVersion cannot be null");
        this.toolBinding = StringUtils.defaultString((String)toolBinding);
        this.constraint = constraint;
        this.setGraphic((Node)Views.helpIcon(I18nContext.i18n().tr("PDF version required: {0}", new String[]{this.constraint.getVersionString()})));
        this.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.selectedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                StaticStudio.eventStudio().broadcast((Object)new AddPdfVersionConstraintEvent(constraint), toolBinding);
            } else {
                StaticStudio.eventStudio().broadcast((Object)new RemovePdfVersionConstraintEvent(constraint), toolBinding);
            }
        });
    }

    public String toolBinding() {
        return this.toolBinding;
    }
}

