/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.prefix;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.core.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.TaskExecutionRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.persistence.PreferencesRepository;
import org.pdfsam.ui.components.prefix.PrefixField;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.model.prefix.Prefix;

public class PrefixPane
extends GridPane
implements TaskParametersBuildStep<MultipleOutputTaskParametersBuilder<?>>,
RestorableView,
ResettableView,
ToolBound {
    private final PrefixField field;
    private final String toolBinding;
    private final PreferencesRepository repository;

    public PrefixPane(String toolBinding, PreferencesRepository repository) {
        this.toolBinding = StringUtils.defaultString((String)toolBinding);
        this.repository = repository;
        this.field = new PrefixField();
        this.initPrefixValue();
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.GRID.css());
        Label label = new Label(I18nContext.i18n().tr("Generated PDF documents name prefix:"));
        GridPane.setValignment((Node)label, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        this.add((Node)label, 0, 0);
        GridPane.setValignment((Node)this.field, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)this.field, (HPos)HPos.LEFT);
        this.add((Node)this.field, 1, 0);
        Text helpIcon = Views.helpIcon("%s\n%s\n%s\n".formatted(I18nContext.i18n().tr("Prefix for the output files name."), I18nContext.i18n().tr("Some special keywords are replaced with runtime values."), I18nContext.i18n().tr("Right click to add these keywords.")));
        GridPane.setValignment((Node)helpIcon, (VPos)VPos.CENTER);
        this.add((Node)helpIcon, 2, 0);
        StaticStudio.eventStudio().add(TaskExecutionRequest.class, e -> {
            if (toolBinding.equals(e.toolId())) {
                repository.saveString("DEFAULT_PREFIX", this.field.getText());
            }
        });
    }

    public void addMenuItemFor(Prefix ... prefixes) {
        this.field.addMenuItemFor(prefixes);
    }

    public void addMenuItemFor(String ... prefixes) {
        this.field.addMenuItemFor(prefixes);
    }

    public final String getText() {
        return this.field.getText();
    }

    public void resetView() {
        this.initPrefixValue();
    }

    public void initPrefixValue() {
        this.field.setText(this.repository.getString("DEFAULT_PREFIX", () -> ApplicationContext.app().persistentSettings().get(StringPersistentProperty.PREFIX).orElse("PDFsam_")));
    }

    public String toolBinding() {
        return this.toolBinding;
    }

    public void apply(MultipleOutputTaskParametersBuilder<?> builder, Consumer<String> onError) {
        builder.prefix(this.getText());
    }

    public void saveStateTo(Map<String, String> data) {
        data.put(StringUtils.defaultString((String)this.getId()) + "prefix", StringUtils.defaultString((String)this.field.getText()));
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.field.setText(Optional.ofNullable(data.get(StringUtils.defaultString((String)this.getId()) + "prefix")).orElse(""));
    }
}

