/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.HBox;
import org.apache.commons.lang3.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.ui.components.selection.PasswordFieldPopupSkin;
import org.pdfsam.ui.components.support.Style;

public class PasswordFieldPopup
extends PopupControl
implements ToolBound {
    private String toolBinding = "";
    private final PasswordFieldPopupContent content = new PasswordFieldPopupContent();
    private PdfDocumentDescriptor pdfDescriptor;

    public PasswordFieldPopup(String toolBinding) {
        this.toolBinding = StringUtils.defaultString((String)toolBinding);
        this.getStyleClass().setAll((Object[])new String[]{"pdfsam-input-password"});
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.setAutoFix(true);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public String toolBinding() {
        return this.toolBinding;
    }

    PasswordFieldPopupContent getPopupContent() {
        return this.content;
    }

    protected Skin<?> createDefaultSkin() {
        return new PasswordFieldPopupSkin(this);
    }

    public void showFor(Node owner, PdfDocumentDescriptor pdfDescriptor, double anchorX, double anchorY) {
        this.pdfDescriptor = pdfDescriptor;
        this.show(owner, anchorX, anchorY);
    }

    private class PasswordFieldPopupContent
    extends HBox {
        private final PasswordField passwordField = new PasswordField();

        public PasswordFieldPopupContent() {
            this.getStyleClass().setAll((Object[])new String[]{"pdfsam-input-password-content"});
            this.passwordField.setPromptText(I18nContext.i18n().tr("Enter the user password"));
            Button doneButton = new Button(I18nContext.i18n().tr("Unlock"));
            doneButton.setGraphic((Node)FontIcon.of((Ikon)UniconsLine.UNLOCK_ALT));
            doneButton.getStyleClass().addAll((Object[])Style.BUTTON.css());
            doneButton.prefHeightProperty().bind((ObservableValue)this.passwordField.heightProperty());
            doneButton.setMaxHeight(Double.NEGATIVE_INFINITY);
            doneButton.setMinHeight(Double.NEGATIVE_INFINITY);
            doneButton.setOnAction(e -> this.requestLoad());
            this.passwordField.setOnAction(e -> this.requestLoad());
            this.getChildren().addAll((Object[])new Node[]{this.passwordField, doneButton});
        }

        public void requestLoad() {
            if (PasswordFieldPopup.this.pdfDescriptor != null) {
                PasswordFieldPopup.this.pdfDescriptor.setPassword(this.passwordField.getText());
                PdfLoadRequest loadEvent = new PdfLoadRequest(PasswordFieldPopup.this.toolBinding());
                loadEvent.add(PasswordFieldPopup.this.pdfDescriptor);
                StaticStudio.eventStudio().broadcast((Object)loadEvent);
            }
            this.passwordField.clear();
            PasswordFieldPopup.this.hide();
        }
    }
}

