/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.multiple;

import java.util.Comparator;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.ui.components.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.components.selection.multiple.SelectionTableRowData;

public enum LongColumn implements SelectionTableColumn<Number>
{
    SIZE{

        @Override
        public String getColumnTitle() {
            return I18nContext.i18n().tr("Size");
        }

        @Override
        public ObservableValue<Number> getObservableValue(SelectionTableRowData data) {
            return new SimpleLongProperty(data.descriptor().getFile().length());
        }

        @Override
        public String getTextValue(Number item) {
            return item != null ? FileUtils.byteCountToDisplaySize((long)item.longValue()) : "";
        }

        @Override
        public Comparator<Number> comparator() {
            return Comparator.comparingLong(Number::longValue);
        }

        @Override
        public Float prefWidth() {
            return Float.valueOf(50.0f);
        }
    }
    ,
    LAST_MODIFIED{

        @Override
        public String getColumnTitle() {
            return I18nContext.i18n().tr("Modified");
        }

        @Override
        public ObservableValue<Number> getObservableValue(SelectionTableRowData data) {
            return new SimpleLongProperty(data.descriptor().getFile().lastModified());
        }

        @Override
        public String getTextValue(Number item) {
            return item != null ? FORMATTER.format((Object)item) : "";
        }

        @Override
        public Comparator<Number> comparator() {
            return Comparator.comparingLong(Number::longValue);
        }

        @Override
        public Float prefWidth() {
            return Float.valueOf(110.0f);
        }
    };

    private static final FastDateFormat FORMATTER;

    static {
        FORMATTER = FastDateFormat.getDateTimeInstance((int)1, (int)2);
    }
}

