/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.multiple;

import java.util.Map;
import javafx.application.Platform;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.IntegerExpression;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.ReferenceStrength;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.ui.components.selection.RemoveSelectedEvent;
import org.pdfsam.ui.components.selection.multiple.DuplicateSelectedEvent;
import org.pdfsam.ui.components.selection.multiple.SelectionTable;
import org.pdfsam.ui.components.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.components.selection.multiple.SelectionTableToolbar;
import org.pdfsam.ui.components.selection.multiple.TableColumnProvider;
import org.sejda.commons.util.RequireUtils;

public class MultipleSelectionPane
extends BorderPane
implements ToolBound,
RestorableView {
    private String toolBinding = "";
    private final SelectionTable table;
    private SimpleIntegerProperty totalValue = new SimpleIntegerProperty(-1);

    public MultipleSelectionPane(String toolBinding, boolean canDuplicate, boolean canMove, TableColumnProvider<?> ... columns) {
        RequireUtils.requireArg((columns.length > 0 ? 1 : 0) != 0, (String)"No column has been selected");
        this.toolBinding = StringUtils.defaultString((String)toolBinding);
        this.setTop((Node)new SelectionTableToolbar(toolBinding, canMove));
        this.table = new SelectionTable(toolBinding, canDuplicate, canMove, columns);
        this.setCenter((Node)this.table);
    }

    public void showTotalPagesLabel() {
        Label total = new Label();
        total.setId("total-label");
        this.totalValue.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> total.setText(I18nContext.i18n().tr("Total pages: {0}", new String[]{newValue.toString()}))));
        this.totalValue.set(0);
        this.setBottom((Node)total);
        StaticStudio.eventStudio().add(PdfLoadRequest.class, this::onTableItemsChange, this.toolBinding(), Integer.MAX_VALUE, ReferenceStrength.STRONG);
        StaticStudio.eventStudio().add(DuplicateSelectedEvent.class, this::onTableItemsChange, this.toolBinding(), Integer.MAX_VALUE, ReferenceStrength.STRONG);
        StaticStudio.eventStudio().add(ClearToolRequest.class, this::onTableItemsChange, this.toolBinding(), Integer.MAX_VALUE, ReferenceStrength.STRONG);
        StaticStudio.eventStudio().add(RemoveSelectedEvent.class, this::onTableItemsChange, this.toolBinding(), Integer.MAX_VALUE, ReferenceStrength.STRONG);
    }

    private void onTableItemsChange(Object event) {
        IntegerBinding binding = IntegerExpression.integerExpression((ObservableIntegerValue)new SimpleIntegerProperty(0)).add(0);
        for (SelectionTableRowData data : this.table.getItems()) {
            binding = binding.add((ObservableNumberValue)data.selectedPages);
        }
        this.totalValue.unbind();
        this.totalValue.bind((ObservableValue)binding);
    }

    public String toolBinding() {
        return this.toolBinding;
    }

    public SelectionTable table() {
        return this.table;
    }

    public void saveStateTo(Map<String, String> data) {
        this.table.saveStateTo(data);
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.table.restoreStateFrom(data);
    }
}

