/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.multiple.move;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.ArrayUtils;
import org.pdfsam.ui.components.selection.multiple.move.MultipleSelectionAndFocus;
import org.pdfsam.ui.components.selection.multiple.move.SelectionAndFocus;
import org.sejda.commons.util.RequireUtils;

public enum MoveType {
    TOP{

        @Override
        public <T> SelectionAndFocus move(Integer[] selected, ObservableList<T> items, int focused) {
            if (this.isSubselection(selected, items)) {
                MultipleSelectionAndFocus newSelection = new MultipleSelectionAndFocus(focused);
                Arrays.parallelSort(selected, Collections.reverseOrder(Integer::compare));
                if (this.isNotFirst(selected)) {
                    LinkedList toMove = new LinkedList();
                    Arrays.stream(selected).forEach(i -> toMove.push(new IntKeyValueItem<Object>((Integer)i, items.remove(i.intValue()))));
                    int addIdx = 0;
                    for (IntKeyValueItem current : toMove) {
                        items.add(addIdx, current.value());
                        newSelection.moveTo(current.key(), addIdx);
                        ++addIdx;
                    }
                    return newSelection;
                }
            }
            return SelectionAndFocus.NULL;
        }
    }
    ,
    UP{

        @Override
        public <T> SelectionAndFocus move(Integer[] selected, ObservableList<T> items, int focused) {
            if (this.isSubselection(selected, items)) {
                MultipleSelectionAndFocus newSelection = new MultipleSelectionAndFocus(focused);
                Arrays.parallelSort((Comparable[])selected);
                if (this.isNotFirst(selected)) {
                    Arrays.stream(selected).forEach(i -> {
                        Collections.swap(items, (int)i, i - 1);
                        newSelection.moveUp((int)i);
                    });
                    return newSelection;
                }
            }
            return SelectionAndFocus.NULL;
        }
    }
    ,
    DOWN{

        @Override
        public <T> SelectionAndFocus move(Integer[] selected, ObservableList<T> items, int focused) {
            if (this.isSubselection(selected, items)) {
                MultipleSelectionAndFocus newSelection = new MultipleSelectionAndFocus(focused);
                Arrays.parallelSort(selected, Collections.reverseOrder(Integer::compare));
                if (this.isNotLast(selected, items)) {
                    Arrays.stream(selected).forEach(i -> {
                        Collections.swap(items, (int)i, i + 1);
                        newSelection.moveDown((int)i);
                    });
                    return newSelection;
                }
            }
            return SelectionAndFocus.NULL;
        }
    }
    ,
    BOTTOM{

        @Override
        public <T> SelectionAndFocus move(Integer[] selected, ObservableList<T> items, int focused) {
            if (this.isSubselection(selected, items)) {
                MultipleSelectionAndFocus newSelection = new MultipleSelectionAndFocus(focused);
                Arrays.parallelSort(selected, Collections.reverseOrder(Integer::compare));
                if (this.isNotLast(selected, items)) {
                    LinkedList toMove = new LinkedList();
                    Arrays.stream(selected).forEach(i -> toMove.push(new IntKeyValueItem<Object>((Integer)i, items.remove(i.intValue()))));
                    toMove.forEach(i -> {
                        items.add(i.value());
                        newSelection.moveTo(i.key(), items.size() - 1);
                    });
                    return newSelection;
                }
            }
            return SelectionAndFocus.NULL;
        }
    };


    boolean isNotFirst(Integer[] selected) {
        return selected[0] > 0;
    }

    boolean isNotLast(Integer[] selected, ObservableList<?> items) {
        return selected[0] < items.size() - 1;
    }

    boolean isSubselection(Integer[] toMove, ObservableList<?> items) {
        return !ArrayUtils.isEmpty((Object[])toMove) && toMove.length < items.size();
    }

    boolean isSingleSelection(Integer[] toMove, ObservableList<?> items) {
        return !ArrayUtils.isEmpty((Object[])toMove) && toMove.length == 1 && items.size() > 1;
    }

    public abstract <T> SelectionAndFocus move(Integer[] var1, ObservableList<T> var2, int var3);

    private record IntKeyValueItem<V>(Integer key, V value) {
        public IntKeyValueItem {
            RequireUtils.requireNotNullArg((Object)key, (String)"Key cannot be null");
        }
    }
}

