/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.single;

import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.ui.components.selection.ToolbarButton;
import org.pdfsam.ui.components.support.Style;

class SingleSelectionPaneToolbar
extends ToolBar
implements ToolBound {
    private String toolBinding = "";

    public SingleSelectionPaneToolbar(Button selectButton, String toolBinding) {
        this.toolBinding = StringUtils.defaultString((String)toolBinding);
        this.getItems().addAll((Object[])new Node[]{selectButton, new ClearButton(toolBinding)});
        this.getStyleClass().add((Object)"selection-tool-bar");
    }

    public String toolBinding() {
        return this.toolBinding;
    }

    static class ClearButton
    extends SplitMenuButton
    implements ToolBound {
        private String ownerModule = "";

        public ClearButton(String ownerModule) {
            this.setId("clear-button");
            this.ownerModule = StringUtils.defaultString((String)ownerModule);
            this.getStyleClass().addAll((Object[])Style.BUTTON.css());
            this.getStyleClass().addAll((Object[])new String[]{"pdfsam-split-button", "toolbar-splitbutton"});
            this.setText(I18nContext.i18n().tr("_Clear"));
            this.setOnAction(this::clear);
            MenuItem clearAllSettings = new MenuItem();
            clearAllSettings.setText(I18nContext.i18n().tr("C_lear all settings"));
            clearAllSettings.setOnAction(this::clearAll);
            this.getItems().add((Object)clearAllSettings);
        }

        public void clear(ActionEvent event) {
            StaticStudio.eventStudio().broadcast((Object)new ClearToolRequest(this.toolBinding(), false, false));
        }

        public void clearAll(ActionEvent event) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Are you sure you want to format your system?", new ButtonType[0]);
            StaticStudio.eventStudio().broadcast((Object)new ClearToolRequest(this.toolBinding(), true, true));
        }

        @EventStation
        public String toolBinding() {
            return this.ownerModule;
        }
    }

    public static class SelectButton
    extends ToolbarButton {
        public SelectButton(String ownerModule) {
            super(ownerModule);
            this.setTooltip(new Tooltip(I18nContext.i18n().tr("Select the PDF file")));
            this.setText(I18nContext.i18n().tr("_Select PDF"));
        }
    }
}

