/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.support;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.pdfsam.core.support.validation.Validator;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXValidationSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FXValidationSupport.class);
    private final ReadOnlyObjectWrapper<ValidationState> validationState = new ReadOnlyObjectWrapper((Object)ValidationState.NOT_VALIDATED);
    private Validator<T> validator = input -> true;

    public void validate(T value) {
        LOG.trace("Validating {}", value);
        if (this.validator.isValid(value)) {
            this.validationState.set((Object)ValidationState.VALID);
        } else {
            this.validationState.set((Object)ValidationState.INVALID);
        }
    }

    public void setValidator(Validator<T> validator) {
        RequireUtils.requireNotNullArg(validator, (String)"Validator cannot be null");
        this.validator = validator;
        this.makeNotValidated();
    }

    public void makeNotValidated() {
        LOG.trace("Making state {}", (Object)ValidationState.NOT_VALIDATED);
        this.validationState.set((Object)ValidationState.NOT_VALIDATED);
    }

    public final ReadOnlyObjectProperty<ValidationState> validationStateProperty() {
        return this.validationState.getReadOnlyProperty();
    }

    public static enum ValidationState {
        VALID,
        INVALID,
        NOT_VALIDATED;

    }
}

