/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.Optional;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfRotator;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.RotateParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.rotation.Rotation;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotateTask
extends BaseTask<RotateParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(RotateTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(RotateParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener(executionContext);
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RotateParameters parameters) throws TaskException {
        for (int sourceIndex = 0; sourceIndex < parameters.getSourceList().size(); ++sourceIndex) {
            PdfSource source = (PdfSource)parameters.getSourceList().get(sourceIndex);
            int fileNumber = this.executionContext().incrementAndGetOutputDocumentsCounter();
            LOG.debug("Opening {}", (Object)source);
            this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)source);
            try {
                this.documentHandler = (PDDocumentHandler)source.open(this.documentLoader);
                this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
                this.documentHandler.setCreatorOnPDDocument();
                File tmpFile = org.sejda.model.util.IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
                LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
                PdfRotator rotator = new PdfRotator(this.documentHandler.getUnderlyingPDDocument());
                for (int page = 1; page <= this.documentHandler.getNumberOfPages(); ++page) {
                    Rotation rotation = parameters.getRotation(sourceIndex, page);
                    if (rotation == Rotation.DEGREES_0) continue;
                    try {
                        rotator.rotate(page, rotation);
                        continue;
                    }
                    catch (PageNotFoundException e) {
                        String warningMessage = String.format("Page %d of %s was skipped, could not be rotated", page, source.getName());
                        this.executionContext().assertTaskIsLenient((Exception)((Object)e));
                        ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).taskWarning(warningMessage, (Exception)((Object)e));
                    }
                }
                this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
                this.documentHandler.setCompress(parameters.isCompress());
                this.documentHandler.savePDDocument(tmpFile, parameters.getOutput().getEncryptionAtRestPolicy());
                String outName = Optional.ofNullable(parameters.getSpecificResultFilename(fileNumber)).orElseGet(() -> NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(fileNumber)));
                this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            }
            finally {
                IOUtils.closeQuietly((Closeable)this.documentHandler);
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(fileNumber).outOf(this.totalSteps);
        }
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Input documents rotated and written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.documentHandler);
    }
}

