/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import org.sejda.commons.LookupTable;
import org.sejda.impl.sambox.component.AnnotationsDistiller;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.exception.TaskPermissionsException;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfMixFragment
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PdfMixFragment.class);
    private LookupTable<PDPage> lookups = new LookupTable();
    private PDDocumentHandler handler;
    private PdfMixInput input;
    private LinkedList<Integer> pages;
    private boolean hasNotReachedTheEnd = true;

    private PdfMixFragment(PdfMixInput input, PDDocumentHandler handler) {
        this.handler = handler;
        this.input = input;
        this.populatePages();
    }

    private void populatePages() {
        this.pages = new LinkedList(this.input.getPages(this.handler.getNumberOfPages()));
    }

    private void populatePagesIfRequired() {
        if (this.pages.isEmpty()) {
            this.hasNotReachedTheEnd = false;
            if (this.input.isRepeatForever()) {
                this.populatePages();
            }
        }
    }

    public PDPage nextPage() {
        PDPage result = this.input.isReverse() ? this.handler.getPage(this.pages.removeLast()) : this.handler.getPage(this.pages.removeFirst());
        this.populatePagesIfRequired();
        return result;
    }

    public boolean hasNextPage() {
        return !this.pages.isEmpty();
    }

    public boolean hasNotReachedTheEnd() {
        return this.hasNotReachedTheEnd;
    }

    public int getNumberOfPages() {
        return this.handler.getNumberOfPages();
    }

    public int getStep() {
        return this.input.getStep();
    }

    public PdfSource<?> source() {
        return this.input.getSource();
    }

    public void addLookupEntry(PDPage current, PDPage importPage) {
        this.lookups.addLookupEntry((Object)current, (Object)importPage);
    }

    public void saintizeAnnotations() {
        SignatureClipper.clipSignatures(new AnnotationsDistiller(this.handler.getUnderlyingPDDocument()).retainRelevantAnnotations(this.lookups).values());
    }

    @Override
    public void close() throws IOException {
        this.handler.close();
        this.lookups.clear();
    }

    public static PdfMixFragment newInstance(PdfMixInput input, TaskExecutionContext executionContext) throws TaskIOException, TaskPermissionsException {
        LOG.debug("Opening input {} with step {} and reverse {}", new Object[]{input.getSource(), input.getStep(), input.isReverse()});
        PDDocumentHandler documentHandler = (PDDocumentHandler)input.getSource().open((PdfSourceOpener)new DefaultPdfSourceOpener(executionContext));
        documentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
        return new PdfMixFragment(input, documentHandler);
    }
}

