/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.model.io;

import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public enum FileType {
    ALL("(*.*)", "*.*", "*"),
    CSV("(*.csv)", "*.csv", "*.CSV"),
    PDF("(*.pdf)", "*.pdf", "*.PDF"),
    TXT("(*.txt)", "*.txt", "*.TXT"),
    LOG("(*.log, *.txt)", "*.log", "*.txt", "*.LOG", "*.TXT"),
    XML("(*.xml)", "*.xml", "*.XML"),
    JSON("(*.json)", "*.json", "*.JSON"),
    HTML("(*.html, *.htm)", "*.htm", "*.html", "*.HTM", "*.HTML");

    private final FileChooser.ExtensionFilter filter;

    private FileType(String description, String ... extensions) {
        this.filter = new FileChooser.ExtensionFilter(description, extensions);
    }

    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }

    public boolean matches(String filename) {
        return this.getFilter().getExtensions().stream().anyMatch(ext -> FilenameUtils.wildcardMatch((String)filename, (String)ext, (IOCase)IOCase.INSENSITIVE));
    }
}

