/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.model.pdf;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ObservableAtomicReference;
import org.pdfsam.model.pdf.PdfDescriptorLoadingStatus;
import org.sejda.commons.util.RequireUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.pdf.PdfVersion;

public class PdfDocumentDescriptor {
    private final ObservableAtomicReference<PdfDescriptorLoadingStatus> loadingStatus = new ObservableAtomicReference<PdfDescriptorLoadingStatus>(PdfDescriptorLoadingStatus.INITIAL);
    private final AtomicInteger references = new AtomicInteger(1);
    private final ObservableAtomicReference<Integer> pages = new ObservableAtomicReference<Integer>(0);
    private String password;
    private final File file;
    private PdfVersion version;
    private final Map<String, String> metadata = new HashMap<String, String>();
    private SortedSet<Integer> validBookmarksLevels = Collections.emptySortedSet();

    private PdfDocumentDescriptor(File file, String password) {
        RequireUtils.requireNotNullArg((Object)file, (String)"Input file is mandatory");
        this.file = file;
        this.password = password;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public PdfFileSource toPdfFileSource() {
        try {
            return PdfFileSource.newInstanceWithPassword((File)this.file, (String)this.password);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(I18nContext.i18n().tr("File \"{0}\" does not exist or is invalid", new String[]{this.file.getName()}), (Throwable)e);
        }
    }

    public String getInformation(String key) {
        return StringUtils.defaultString((String)this.metadata.get(key));
    }

    public void setInformationDictionary(Map<String, String> info) {
        this.metadata.clear();
        this.metadata.putAll(info);
    }

    public void putInformation(String key, String value) {
        this.metadata.put(key, value);
    }

    public void pages(int newValue) {
        this.pages.set(newValue);
    }

    public ObservableValue<PdfDescriptorLoadingStatus> loadingStatus() {
        return this.loadingStatus;
    }

    public ObservableValue<Integer> pages() {
        return this.pages;
    }

    public void moveStatusTo(PdfDescriptorLoadingStatus destination) {
        this.loadingStatus.set(this.loadingStatus.getValue().moveTo(destination));
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasPassword() {
        return StringUtils.isNotBlank((CharSequence)this.password);
    }

    public String getVersionString() {
        return Optional.ofNullable(this.version).map(PdfVersion::getVersionString).orElse("");
    }

    public PdfVersion getVersion() {
        return this.version;
    }

    public void setVersion(PdfVersion version) {
        this.version = version;
    }

    public File getFile() {
        return this.file;
    }

    public void setValidBookmarksLevels(Set<Integer> levels) {
        this.validBookmarksLevels = new TreeSet<Integer>();
        if (Objects.nonNull(levels)) {
            this.validBookmarksLevels.addAll(levels);
        }
    }

    public SortedSet<Integer> getValidBookmarksLevels() {
        return this.validBookmarksLevels;
    }

    public boolean hasReferences() {
        return this.references.get() > 0;
    }

    public boolean release() {
        return this.references.decrementAndGet() <= 0;
    }

    public void releaseAll() {
        this.references.set(0);
    }

    public PdfDocumentDescriptor retain() {
        this.references.incrementAndGet();
        return this;
    }

    public static PdfDocumentDescriptor newDescriptor(File file, String password) {
        return new PdfDocumentDescriptor(file, password);
    }

    public static PdfDocumentDescriptor newDescriptorNoPassword(File file) {
        return new PdfDocumentDescriptor(file, null);
    }
}

