/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.model.ui;

import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ComboItem<T> {
    private final T key;
    private final String description;

    public ComboItem(T key, String description) {
        this.key = key;
        this.description = description;
    }

    public T key() {
        return this.key;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComboItem)) {
            return false;
        }
        ComboItem item = (ComboItem)other;
        return Objects.equals(this.key, item.key());
    }

    public static ComboItem<String> fromLocale(Locale locale) {
        return new ComboItem<String>(locale.toLanguageTag(), StringUtils.capitalize((String)locale.getDisplayName(locale)));
    }

    public static <K> ComboItem<K> keyWithEmptyValue(K key) {
        return new ComboItem<K>(key, "");
    }
}

