/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.SeekableSource;

public class BufferedSeekableSource
implements SeekableSource {
    private final ByteBuffer buffer = ByteBuffer.allocate(Integer.getInteger("org.sejda.io.buffered.input.size", 8192));
    private final SeekableSource wrapped;
    private long position;
    private final long size;

    public BufferedSeekableSource(SeekableSource wrapped) {
        RequireUtils.requireNotNullArg((Object)wrapped, (String)"Input decorated SeekableSource cannot be null");
        this.wrapped = wrapped;
        this.size = wrapped.size();
        this.buffer.limit(0);
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    @Override
    public void requireOpen() throws IOException {
        this.wrapped.requireOpen();
    }

    @Override
    public String id() {
        return this.wrapped.id();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableSource position(long newPosition) throws IOException {
        RequireUtils.requireArg((newPosition >= 0L ? 1 : 0) != 0, (String)"Cannot set position to a negative value");
        if (newPosition != this.position) {
            long newBufPosition = newPosition - this.position + (long)this.buffer.position();
            if (newBufPosition >= 0L && newBufPosition < (long)this.buffer.limit()) {
                this.buffer.position((int)newBufPosition);
            } else {
                this.buffer.limit(0);
                this.wrapped.position(newPosition);
            }
            this.position = Math.min(newPosition, this.size);
        }
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.wrapped);
        this.buffer.clear();
        this.buffer.limit(0);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.requireOpen();
        this.buffer.limit(0);
        this.wrapped.position(this.position);
        int read = this.wrapped.read(dst);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        this.requireOpen();
        if (this.ensureBuffer() > 0) {
            ++this.position;
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    private int ensureBuffer() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            this.wrapped.read(this.buffer);
            this.buffer.flip();
        }
        return this.buffer.remaining();
    }

    protected SeekableSource wrapped() {
        return this.wrapped;
    }

    @Override
    public SeekableSource view(long startingPosition, long length) throws IOException {
        this.requireOpen();
        return new BufferedSeekableSource(this.wrapped.view(startingPosition, length));
    }
}

