/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.BaseSeekableSource;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSourceView;
import org.sejda.io.ThreadBoundCopiesSupplier;

public class FileChannelSeekableSource
extends BaseSeekableSource {
    private final FileChannel channel;
    private Path path;
    private final long size;
    private final ThreadBoundCopiesSupplier<FileChannelSeekableSource> localCopiesSupplier = new ThreadBoundCopiesSupplier<FileChannelSeekableSource>(() -> new FileChannelSeekableSource(this.path));

    public FileChannelSeekableSource(Path path) {
        super(Optional.ofNullable(path).map(Path::toAbsolutePath).map(Path::toString).orElseThrow(() -> new IllegalArgumentException("Input path cannot be null")));
        try {
            this.channel = FileChannel.open(path, StandardOpenOption.READ);
            this.size = this.channel.size();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.path = path;
    }

    public FileChannelSeekableSource(File file) {
        this(Optional.ofNullable(file).map(File::toPath).orElseThrow(() -> new IllegalArgumentException("Input file cannot be null")));
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public SeekableSource position(long newPosition) throws IOException {
        RequireUtils.requireArg((newPosition >= 0L ? 1 : 0) != 0, (String)"Cannot set position to a negative value");
        this.channel.position(newPosition);
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.close(this.localCopiesSupplier);
        IOUtils.close((Closeable)this.channel);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.requireOpen();
        return this.channel.read(dst);
    }

    @Override
    public int read() throws IOException {
        this.requireOpen();
        ByteBuffer buffer = ByteBuffer.allocate(1);
        if (this.channel.read(buffer) > 0) {
            buffer.flip();
            return buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public SeekableSource view(long startingPosition, long length) throws IOException {
        this.requireOpen();
        return new SeekableSourceView(this.localCopiesSupplier, this.id(), startingPosition, length);
    }
}

