/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.BaseSeekableSource;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSourceView;
import org.sejda.io.ThreadBoundCopiesSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMappedSeekableSource
extends BaseSeekableSource {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMappedSeekableSource.class);
    private static final long MB_256 = 0x10000000L;
    private final long pageSize = Long.getLong("org.sejda.io.memory.mapped.page.size", 0x10000000L);
    private final List<ByteBuffer> pages = new ArrayList<ByteBuffer>();
    private final Arena arena;
    private final long size;
    private final ThreadBoundCopiesSupplier<MemoryMappedSeekableSource> localCopiesSupplier = new ThreadBoundCopiesSupplier<MemoryMappedSeekableSource>(() -> new MemoryMappedSeekableSource(this));
    private long position;

    public MemoryMappedSeekableSource(Path path) throws IOException {
        super(Optional.ofNullable(path).map(Path::toAbsolutePath).map(Path::toString).orElseThrow(() -> new IllegalArgumentException("Input path cannot be null")));
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            this.size = channel.size();
            int zeroBasedPagesNumber = (int)(channel.size() / this.pageSize);
            this.arena = Arena.ofShared();
            for (int i = 0; i <= zeroBasedPagesNumber; ++i) {
                if (i == zeroBasedPagesNumber) {
                    this.pages.add(i, channel.map(FileChannel.MapMode.READ_ONLY, (long)i * this.pageSize, channel.size() - (long)i * this.pageSize, this.arena).asByteBuffer());
                    continue;
                }
                this.pages.add(i, channel.map(FileChannel.MapMode.READ_ONLY, (long)i * this.pageSize, this.pageSize, this.arena).asByteBuffer());
            }
            LOG.debug("Created MemoryMappedSeekableSource with " + this.pages.size() + " pages");
        }
    }

    public MemoryMappedSeekableSource(File file) throws IOException {
        this(Optional.ofNullable(file).map(File::toPath).orElseThrow(() -> new IllegalArgumentException("Input file cannot be null")));
    }

    private MemoryMappedSeekableSource(MemoryMappedSeekableSource parent) {
        super(parent.id());
        this.size = parent.size;
        for (ByteBuffer page : parent.pages) {
            this.pages.add(page.duplicate());
        }
        this.arena = null;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SeekableSource position(long position) {
        RequireUtils.requireArg((position >= 0L ? 1 : 0) != 0, (String)"Cannot set position to a negative value");
        this.position = Math.min(position, this.size);
        return this;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.requireOpen();
        int zeroBasedPagesNumber = (int)(this.position() / this.pageSize);
        ByteBuffer page = this.pages.get(zeroBasedPagesNumber);
        int relativePosition = (int)(this.position() - (long)zeroBasedPagesNumber * this.pageSize);
        if (relativePosition < page.limit()) {
            int readBytes;
            int read = this.readPage(dst, zeroBasedPagesNumber, relativePosition);
            while (dst.hasRemaining() && (readBytes = this.readPage(dst, ++zeroBasedPagesNumber, 0)) != 0) {
                read += readBytes;
            }
            this.position += (long)read;
            return read;
        }
        return -1;
    }

    private int readPage(ByteBuffer dst, int pageNumber, int bufferPosition) {
        if (pageNumber < this.pages.size()) {
            ByteBuffer page = this.pages.get(pageNumber);
            page.position(bufferPosition);
            if (page.hasRemaining()) {
                int toRead = Math.min(dst.remaining(), page.remaining());
                byte[] bufToRead = new byte[toRead];
                page.get(bufToRead);
                dst.put(bufToRead);
                return toRead;
            }
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        this.requireOpen();
        int zeroBasedPagesNumber = (int)(this.position() / this.pageSize);
        ByteBuffer page = this.pages.get(zeroBasedPagesNumber);
        int relativePosition = (int)(this.position() - (long)zeroBasedPagesNumber * this.pageSize);
        if (relativePosition < page.limit()) {
            ++this.position;
            return page.get(relativePosition);
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.close(this.localCopiesSupplier);
        Optional.ofNullable(this.arena).filter(a -> a.scope().isAlive()).ifPresent(Arena::close);
        this.pages.clear();
    }

    @Override
    public SeekableSource view(long startingPosition, long length) throws IOException {
        this.requireOpen();
        return new SeekableSourceView(this.localCopiesSupplier, this.id(), startingPosition, length);
    }
}

