/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.SeekableSource;

class SeekableSourceInputStream
extends InputStream {
    private final SeekableSource wrapped;

    SeekableSourceInputStream(SeekableSource wrapped) {
        RequireUtils.requireNotNullArg((Object)wrapped, (String)"Cannot decorate a null instance");
        this.wrapped = wrapped;
    }

    @Override
    public int read() throws IOException {
        return this.getSource().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.available() > 0) {
            return this.getSource().read(ByteBuffer.wrap(b, 0, Math.min(b.length, this.available())));
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.available() > 0) {
            return this.getSource().read(ByteBuffer.wrap(b, Math.min(b.length, offset), Math.min(length, Math.min(b.length - offset, this.available()))));
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        SeekableSource source = this.getSource();
        return (int)Math.max(0L, source.size() - source.position());
    }

    @Override
    public long skip(long offset) throws IOException {
        SeekableSource source = this.getSource();
        long start = source.position();
        return source.forward(Math.min(offset, (long)this.available())).position() - start;
    }

    private SeekableSource getSource() {
        RequireUtils.requireState((boolean)this.wrapped.isOpen(), (String)"The SeekableSource has been closed");
        return this.wrapped;
    }
}

