/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.split;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SingleSelectionModel;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.SplitParametersBuilder;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ComboItem;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.split.SplitParametersBuilderCreator;
import org.sejda.model.input.PdfSource;
import org.sejda.model.parameter.SimpleSplitParameters;
import org.sejda.model.pdf.page.PredefinedSetOfPages;

class SplitAfterPredefinedSetOfPagesRadioButton
extends RadioButton
implements SplitParametersBuilderCreator,
RestorableView,
ResettableView {
    private final ComboBox<ComboItem<PredefinedSetOfPages>> combo;

    public SplitAfterPredefinedSetOfPagesRadioButton(ComboBox<ComboItem<PredefinedSetOfPages>> combo) {
        super(I18nContext.i18n().tr("Split after"));
        this.combo = combo;
        combo.getSelectionModel().selectFirst();
    }

    public void resetView() {
        this.combo.getSelectionModel().selectFirst();
    }

    public SimpleSplitParametersBuilder getBuilder(Consumer<String> onError) {
        ComboItem selected = (ComboItem)this.combo.getSelectionModel().getSelectedItem();
        if (selected != null) {
            return new SimpleSplitParametersBuilder((PredefinedSetOfPages)selected.key());
        }
        onError.accept(I18nContext.i18n().tr("No page selected"));
        return null;
    }

    public void saveStateTo(Map<String, String> data) {
        ComboItem selected;
        if (this.isSelected()) {
            data.put("splitAfterPredefined", Boolean.TRUE.toString());
        }
        if ((selected = (ComboItem)this.combo.getSelectionModel().getSelectedItem()) != null) {
            data.put("splitAfterPredefined.combo", StringUtils.defaultString((String)((PredefinedSetOfPages)selected.key()).toString()));
        }
    }

    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("splitAfterPredefined")).map(Boolean::valueOf).ifPresent(arg_0 -> ((SplitAfterPredefinedSetOfPagesRadioButton)this).setSelected(arg_0));
        Optional.ofNullable(data.get("splitAfterPredefined.combo")).map(PredefinedSetOfPages::valueOf).flatMap(key -> this.combo.getItems().stream().filter(i -> ((PredefinedSetOfPages)i.key()).equals(key)).findFirst()).ifPresent(arg_0 -> ((SingleSelectionModel)this.combo.getSelectionModel()).select(arg_0));
    }

    static class SimpleSplitParametersBuilder
    extends SplitParametersBuilder<SimpleSplitParameters> {
        private final PredefinedSetOfPages pages;

        SimpleSplitParametersBuilder(PredefinedSetOfPages pages) {
            this.pages = pages;
        }

        public SimpleSplitParameters build() {
            SimpleSplitParameters params = new SimpleSplitParameters(this.pages);
            params.setCompress(this.isCompress());
            params.setExistingOutputPolicy(this.existingOutput());
            params.setVersion(this.getVersion());
            params.setOutput(this.getOutput());
            params.setOutputPrefix(this.getPrefix());
            params.addSource((PdfSource)this.getSource());
            params.setOptimizationPolicy(this.getOptimizationPolicy());
            params.discardOutline(this.isDiscardBookmarks());
            return params;
        }
    }
}

