/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.split;

import java.util.Map;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.pdfsam.core.support.params.SinglePdfSourceMultipleOutputParametersBuilder;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ComboItem;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.split.SplitAfterPredefinedSetOfPagesRadioButton;
import org.pdfsam.tools.split.SplitAfterRadioButton;
import org.pdfsam.tools.split.SplitByEveryRadioButton;
import org.pdfsam.tools.split.SplitParametersBuilderCreator;
import org.pdfsam.ui.components.commons.RadioButtonDrivenTextFieldsPane;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.pdf.page.PredefinedSetOfPages;

class SplitOptionsPane
extends VBox
implements SplitParametersBuilderCreator,
RestorableView,
ResettableView {
    private final ToggleGroup group = new ToggleGroup();
    private final SplitAfterPredefinedSetOfPagesRadioButton splitAfterPredefined;
    private final SplitAfterRadioButton splitAfter;
    private final SplitByEveryRadioButton splitByEvery;

    SplitOptionsPane() {
        super(5.0);
        ComboBox predefinedCombo = new ComboBox();
        predefinedCombo.getItems().add((Object)new ComboItem((Object)PredefinedSetOfPages.ALL_PAGES, I18nContext.i18n().tr("Every page")));
        predefinedCombo.getItems().add((Object)new ComboItem((Object)PredefinedSetOfPages.EVEN_PAGES, I18nContext.i18n().tr("Even pages")));
        predefinedCombo.getItems().add((Object)new ComboItem((Object)PredefinedSetOfPages.ODD_PAGES, I18nContext.i18n().tr("Odd pages")));
        this.splitAfterPredefined = new SplitAfterPredefinedSetOfPagesRadioButton((ComboBox<ComboItem<PredefinedSetOfPages>>)predefinedCombo);
        ValidableTextField splitAfterField = new ValidableTextField();
        this.splitAfter = new SplitAfterRadioButton(splitAfterField);
        ValidableTextField splitByEveryField = new ValidableTextField();
        this.splitByEvery = new SplitByEveryRadioButton(splitByEveryField);
        RadioButtonDrivenTextFieldsPane grid = new RadioButtonDrivenTextFieldsPane(this.group);
        this.splitAfterPredefined.setToggleGroup(this.group);
        this.splitAfter.setToggleGroup(this.group);
        this.splitByEvery.setToggleGroup(this.group);
        grid.addRow((RadioButton)this.splitAfterPredefined, (Region)predefinedCombo, Views.helpIcon((String)I18nContext.i18n().tr("Split the document after the given page numbers")));
        grid.addRow((RadioButton)this.splitAfter, (Region)splitAfterField, Views.helpIcon((String)I18nContext.i18n().tr("Split the document after the given page numbers")));
        grid.addRow((RadioButton)this.splitByEvery, (Region)splitByEveryField, Views.helpIcon((String)I18nContext.i18n().tr("Splits the PDF every \"n\" pages creating documents of \"n\" pages each")));
        this.splitAfterPredefined.setSelected(true);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{grid});
    }

    void setMaxPages(Integer value) {
        this.splitByEvery.setMaxPages(value);
    }

    @Override
    public SinglePdfSourceMultipleOutputParametersBuilder<? extends AbstractSplitByPageParameters> getBuilder(Consumer<String> onError) {
        return ((SplitParametersBuilderCreator)this.group.getSelectedToggle()).getBuilder(onError);
    }

    public void saveStateTo(Map<String, String> data) {
        this.splitAfterPredefined.saveStateTo(data);
        this.splitAfter.saveStateTo(data);
        this.splitByEvery.saveStateTo(data);
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.splitAfterPredefined.restoreStateFrom(data);
        this.splitAfter.restoreStateFrom(data);
        this.splitByEvery.restoreStateFrom(data);
    }

    public void resetView() {
        this.splitAfterPredefined.resetView();
        this.splitAfter.resetView();
        this.splitByEvery.resetView();
        this.splitAfterPredefined.setSelected(true);
    }
}

