/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.split;

import jakarta.inject.Named;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.injector.Provides;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.tool.ToolDescriptor;
import org.pdfsam.model.tool.ToolDescriptorBuilder;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.tool.ToolPriority;
import org.pdfsam.persistence.PreferencesRepository;
import org.pdfsam.tools.split.SplitToolPanel;
import org.pdfsam.ui.components.io.BrowsableField;
import org.pdfsam.ui.components.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.prefix.PrefixPane;
import org.pdfsam.ui.components.tool.Footer;
import org.pdfsam.ui.components.tool.OpenButton;
import org.pdfsam.ui.components.tool.RunButton;

@Auto
public class SplitTool
implements Tool {
    static final String TOOL_ID = "split.simple";
    private final ToolDescriptor descriptor = ToolDescriptorBuilder.builder().category(ToolCategory.SPLIT).inputTypes(new ToolInputOutputType[]{ToolInputOutputType.SINGLE_PDF}).name(I18nContext.i18n().tr("Split")).description(I18nContext.i18n().tr("Split a PDF document at the given page numbers.")).priority(ToolPriority.HIGH.getPriority()).supportURL("https://pdfsam.org/pdf-split/").build();

    public ToolDescriptor descriptor() {
        return this.descriptor;
    }

    public Pane panel() {
        return (Pane)ApplicationContext.app().instance(SplitToolPanel.class);
    }

    public String id() {
        return TOOL_ID;
    }

    public Node graphic() {
        FontIcon icon = new FontIcon((Ikon)UniconsLine.IMAGE_BROKEN);
        icon.getStyleClass().addAll((Object[])new String[]{this.descriptor().category().styleClass(), "tool-icon"});
        return icon;
    }

    public static class ModuleConfig {
        @Provides
        @Named(value="split.simplefield")
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Provides
        @Named(value="split.simplepane")
        public PdfDestinationPane destinationPane(@Named(value="split.simplefield") BrowsableOutputDirectoryField outputField) {
            PdfDestinationPane panel = new PdfDestinationPane((BrowsableField)outputField, SplitTool.TOOL_ID, new PdfDestinationPane.DestinationPanelFields[]{PdfDestinationPane.DestinationPanelFields.DISCARD_BOOKMARKS});
            panel.enableSameAsSourceItem();
            return panel;
        }

        @Provides
        @Named(value="split.simplefooter")
        public Footer footer(RunButton runButton, @Named(value="split.simpleopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, SplitTool.TOOL_ID);
        }

        @Provides
        @Named(value="split.simpleopenButton")
        public OpenButton openButton() {
            return new OpenButton(SplitTool.TOOL_ID, ToolInputOutputType.MULTIPLE_PDF);
        }

        @Provides
        @Named(value="split.simpleprefix")
        public PrefixPane prefixPane() {
            return new PrefixPane(SplitTool.TOOL_ID, new PreferencesRepository("/org/pdfsam/user/conf/split.simple"));
        }
    }
}

