/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import org.pdfsam.core.context.ApplicationContext;

public class DirectoryChooserWithWorkingDirectory {
    private final DirectoryChooser wrapped = new DirectoryChooser();

    DirectoryChooserWithWorkingDirectory() {
        ApplicationContext.app().runtimeState().workingPath().subscribe(p -> this.wrapped.setInitialDirectory((File)p.map(Path::toFile).orElse(null)));
    }

    final void setTitle(String value) {
        this.wrapped.setTitle(value);
    }

    public final void setInitialDirectory(Path value) {
        this.wrapped.setInitialDirectory((File)Optional.ofNullable(value).map(Path::toFile).orElse(null));
    }

    public Path showDialog(Window ownerWindow) {
        Path selected;
        if (Optional.ofNullable(this.wrapped.getInitialDirectory()).map(File::toPath).filter(Predicate.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).isPresent()) {
            this.wrapped.setInitialDirectory(null);
        }
        if (Objects.nonNull(selected = (Path)Optional.ofNullable(this.wrapped.showDialog(ownerWindow)).map(File::toPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).orElse(null))) {
            ApplicationContext.app().runtimeState().maybeWorkingPath(selected);
        }
        return selected;
    }
}

