/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.extract;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.ConversionUtils;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.extract.ExtractParametersBuilder;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.pdf.page.PagesSelection;

class ExtractOptionsPane
extends GridPane
implements TaskParametersBuildStep<ExtractParametersBuilder>,
RestorableView,
ResettableView {
    private final ValidableTextField field = new ValidableTextField();
    private final CheckBox separateFile = new CheckBox(I18nContext.i18n().tr("A separate file for each set of pages"));

    ExtractOptionsPane() {
        this.separateFile.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Each continuous series of pages will generate a separate PDF file")));
        this.separateFile.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.separateFile.setId("separateFile");
        this.field.setOnEnterValidation(true);
        this.field.setEnableInvalidStyle(true);
        this.field.setPromptText(I18nContext.i18n().tr("Pages to extract (ex: 2 or 5-23 or 2,5-7,12- or 3,last)"));
        this.field.setValidator(v -> {
            try {
                return !ConversionUtils.toPagesSelectionSet((String)this.field.getText()).isEmpty();
            }
            catch (ConversionException e) {
                return false;
            }
        });
        this.field.setErrorMessage(I18nContext.i18n().tr("Invalid page ranges"));
        this.field.setId("extractRanges");
        this.field.setPrefWidth(400.0);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.GRID.css());
        Label label = new Label(I18nContext.i18n().tr("Extract pages:"));
        GridPane.setValignment((Node)label, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        this.add((Node)label, 0, 0);
        GridPane.setValignment((Node)this.field, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)this.field, (HPos)HPos.LEFT);
        this.add((Node)this.field, 1, 0);
        Text helpIcon = Views.helpIcon((String)I18nContext.i18n().tr("Comma separated page numbers or ranges to extract (ex: 2 or 5-23 or 2,5-7,12- or 3,last)"));
        GridPane.setValignment((Node)helpIcon, (VPos)VPos.CENTER);
        this.add((Node)helpIcon, 2, 0);
        GridPane.setValignment((Node)this.separateFile, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)this.separateFile, (HPos)HPos.LEFT);
        this.add((Node)this.separateFile, 0, 1, 3, 1);
    }

    public void apply(ExtractParametersBuilder builder, Consumer<String> onError) {
        this.field.validate();
        if (this.field.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            try {
                builder.pagesSelection((Set<PagesSelection>)ConversionUtils.toPagesSelectionSet((String)this.field.getText()));
                builder.separateForEachRange(this.separateFile.isSelected());
            }
            catch (ConversionException e) {
                onError.accept(e.getMessage());
            }
        } else {
            onError.accept(I18nContext.i18n().tr("Invalid page ranges"));
        }
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("pages", StringUtils.defaultString((String)this.field.getText()));
        data.put("separateFile", Boolean.toString(this.separateFile.isSelected()));
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.field.setText(Optional.ofNullable(data.get("pages")).orElse(""));
        this.separateFile.setSelected(Boolean.parseBoolean(data.get("separateFile")));
    }

    public void resetView() {
        this.field.clear();
        this.separateFile.setSelected(false);
    }
}

