/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.extract;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.tools.extract.ExtractOptionsPane;
import org.pdfsam.tools.extract.ExtractParametersBuilder;
import org.pdfsam.tools.extract.ExtractSelectionPane;
import org.pdfsam.ui.components.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.prefix.PrefixPane;
import org.pdfsam.ui.components.support.Views;
import org.pdfsam.ui.components.tool.BaseToolPanel;
import org.pdfsam.ui.components.tool.Footer;
import org.sejda.model.prefix.Prefix;

public class ExtractToolPanel
extends BaseToolPanel {
    private final ExtractSelectionPane selectionPane = new ExtractSelectionPane("extract");
    private final ExtractOptionsPane extractOptions = new ExtractOptionsPane();
    private final BrowsableOutputDirectoryField destinationDirectoryField;
    private final PdfDestinationPane destinationPane;
    private final PrefixPane prefix;

    @Inject
    public ExtractToolPanel(@Named(value="extractfield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="extractpane") PdfDestinationPane destinationPane, @Named(value="extractfooter") Footer footer, @Named(value="extractprefix") PrefixPane prefix) {
        super("extract", footer);
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.prefix = prefix;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    protected ExtractParametersBuilder getBuilder(Consumer<String> onError) {
        ExtractParametersBuilder builder = new ExtractParametersBuilder();
        this.extractOptions.apply(builder, onError);
        this.selectionPane.apply(builder, onError);
        this.destinationDirectoryField.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        this.prefix.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        return builder;
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.extractOptions.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        if (data.containsKey("input")) {
            data.put("input.0", data.get("input"));
            data.put("input.password.0", data.get("input.password"));
            data.put("input.size", "1");
        }
        this.selectionPane.restoreStateFrom(data);
        this.extractOptions.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        TitledPane prefixTitled = Views.titledPane((String)I18nContext.i18n().tr("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.FILENUMBER});
        this.prefix.addMenuItemFor(new String[]{"[TOTAL_FILESNUMBER]"});
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)I18nContext.i18n().tr("Extract settings"), (Node)this.extractOptions), Views.titledPane((String)I18nContext.i18n().tr("Output settings"), (Node)this.destinationPane), prefixTitled});
        return pane;
    }

    @EventStation
    public String id() {
        return "extract";
    }

    @EventListener
    public void onClearModule(ClearToolRequest e) {
        if (e.clearEverything()) {
            this.extractOptions.resetView();
            this.prefix.resetView();
            this.destinationPane.resetView();
        }
    }
}

