/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.context;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.sejda.core.Sejda;
import org.sejda.core.context.DefaultTasksRegistry;
import org.sejda.core.context.SejdaConfiguration;
import org.sejda.core.context.TasksRegistry;
import org.sejda.core.context.XmlConfigurationStrategy;
import org.sejda.core.context.XmlConfigurationStreamProvider;
import org.sejda.core.notification.strategy.NotificationStrategy;
import org.sejda.model.exception.ConfigurationException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskNotFoundException;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSejdaConfiguration
implements SejdaConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSejdaConfiguration.class);
    private Class<? extends NotificationStrategy> notificationStrategy;
    private final TasksRegistry tasksRegistry = new DefaultTasksRegistry();
    private boolean validation;
    private boolean ignoreXmlConfiguration;

    DefaultSejdaConfiguration() {
        LOG.info("Configuring Sejda {}", (Object)Sejda.VERSION);
        this.initialize();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Configured tasks:");
            this.tasksRegistry.getTasks().forEach((p, t) -> LOG.trace(String.format("%s executed by -> %s", p, t)));
        }
    }

    private void initialize() {
        XmlConfigurationStrategy configStrategy;
        try {
            configStrategy = XmlConfigurationStrategy.newInstance(new XmlConfigurationStreamProvider());
        }
        catch (ConfigurationException e) {
            throw new SejdaRuntimeException("Unable to complete Sejda configuration ", (Throwable)e);
        }
        this.notificationStrategy = configStrategy.getNotificationStrategy();
        LOG.trace("Notification strategy: {}", this.notificationStrategy);
        this.validation = configStrategy.isValidation();
        LOG.trace("Validation: {}", (Object)this.validation);
        this.ignoreXmlConfiguration = configStrategy.isIgnoreXmlConfiguration();
        LOG.trace("Validation, ignore xml configuration: {}", (Object)this.ignoreXmlConfiguration);
        configStrategy.getTasksMap().forEach(this.tasksRegistry::addTask);
    }

    public static SejdaConfiguration getInstance() {
        return DefaultSejdaConfigurationHolder.CONFIGURATION;
    }

    @Override
    public Class<? extends NotificationStrategy> getNotificationStrategy() {
        return this.notificationStrategy;
    }

    @Override
    public Task<? extends TaskParameters> getTask(TaskParameters parameters) throws TaskException {
        Class<?> parametersClass = parameters.getClass();
        Class<? extends Task> taskClass = Optional.ofNullable(this.tasksRegistry.getTask(parametersClass)).orElseThrow(() -> new TaskNotFoundException(String.format("Unable to find a Task class able to execute %s", parametersClass)));
        try {
            return taskClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new TaskException("Error instantiating the task", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TaskException(String.format("The task %s doesn't define a public no-args contructor.", taskClass), (Throwable)e);
        }
    }

    @Override
    public Class<? extends Task> getTaskClass(TaskParameters parameters) throws TaskException {
        Class<?> parametersClass = parameters.getClass();
        return Optional.ofNullable(this.tasksRegistry.getTask(parametersClass)).orElseThrow(() -> new TaskNotFoundException(String.format("Unable to find a Task class able to execute %s", parametersClass)));
    }

    @Override
    public boolean isValidation() {
        return this.validation;
    }

    @Override
    public boolean isValidationIgnoringXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    TasksRegistry getTasksRegistry() {
        return this.tasksRegistry;
    }

    private static final class DefaultSejdaConfigurationHolder {
        static final SejdaConfiguration CONFIGURATION = new DefaultSejdaConfiguration();

        private DefaultSejdaConfigurationHolder() {
        }
    }
}

