/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.context;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.context.ConfigurationStreamProvider;
import org.sejda.model.exception.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XmlConfigurationStreamProvider
implements ConfigurationStreamProvider {
    private static final Logger LOG = LoggerFactory.getLogger(XmlConfigurationStreamProvider.class);
    private static final List<String> CONFIG_FILES = Arrays.asList("sejda.xml", "sejda.pro.xml", "sejda.default.xml");

    XmlConfigurationStreamProvider() {
    }

    @Override
    public InputStream getConfigurationStream() throws ConfigurationException {
        return Optional.ofNullable(this.getConfiguration()).orElseThrow(() -> new ConfigurationException("Unable to find xml configuration file"));
    }

    private InputStream getConfiguration() throws ConfigurationException {
        String userConfigFileName = System.getProperty("sejda.config.file");
        if (StringUtils.isNotBlank((CharSequence)userConfigFileName)) {
            return this.getCustomConfigurationStream(userConfigFileName);
        }
        return this.getDefaultConfigurationStream();
    }

    private InputStream getCustomConfigurationStream(String userConfigFileName) throws ConfigurationException {
        LOG.trace("Loading Sejda configuration form {}", (Object)userConfigFileName);
        InputStream configStream = ClassLoader.getSystemResourceAsStream(userConfigFileName);
        if (Objects.nonNull(configStream)) {
            return configStream;
        }
        try {
            LOG.trace("Searching Sejda configuration on filesystem");
            return new FileInputStream(userConfigFileName);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(String.format("Unable to access the provided configuration file [%s]", userConfigFileName), (Throwable)e);
        }
    }

    private InputStream getDefaultConfigurationStream() {
        for (String configFile : CONFIG_FILES) {
            LOG.trace("Loading Sejda configuration form {}", (Object)configFile);
            InputStream result = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFile);
            if (Objects.nonNull(result)) {
                return result;
            }
            LOG.trace("Couldn't find configuration file {}", (Object)configFile);
        }
        return null;
    }
}

