/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.service;

import jakarta.validation.ConstraintViolation;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.sejda.core.context.DefaultSejdaConfiguration;
import org.sejda.core.context.SejdaConfiguration;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.service.TaskExecutionService;
import org.sejda.core.validation.DefaultValidationContext;
import org.sejda.model.exception.InvalidTaskParametersException;
import org.sejda.model.exception.TaskException;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTaskExecutionService
implements TaskExecutionService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTaskExecutionService.class);
    private final SejdaConfiguration configuration;

    public DefaultTaskExecutionService() {
        this(DefaultSejdaConfiguration.getInstance());
    }

    public DefaultTaskExecutionService(SejdaConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(TaskParameters parameters) {
        TaskExecutionContext executionContext = null;
        LOG.trace("Starting execution for {}", (Object)parameters);
        try {
            this.validateIfRequired(parameters);
            executionContext = new TaskExecutionContext(this.configuration.getTask(parameters), parameters.isLenient());
            LOG.info("Starting task ({}) execution.", (Object)executionContext.task());
            this.preExecution(executionContext);
            this.actualExecution(parameters, executionContext);
            this.postExecution(executionContext);
        }
        catch (InvalidTaskParametersException i) {
            LOG.error("Task execution failed due to invalid parameters: " + String.join((CharSequence)". ", i.getReasons()), (Throwable)i);
            this.executionFailed((Exception)((Object)i), executionContext);
        }
        catch (TaskException e) {
            LOG.error(String.format("Task (%s) execution failed", Optional.ofNullable(executionContext).map(c -> c.task().toString()).orElse("")), (Throwable)e);
            this.executionFailed((Exception)((Object)e), executionContext);
        }
        catch (RuntimeException e) {
            this.executionFailed(e, executionContext);
            throw e;
        }
    }

    private void executionFailed(Exception e, TaskExecutionContext executionContext) {
        if (executionContext == null) {
            ApplicationEventsNotifier.notifyEvent(NotifiableTaskMetadata.NULL).taskFailed(e);
        } else {
            ApplicationEventsNotifier.notifyEvent(executionContext.notifiableTaskMetadata()).taskFailed(e);
        }
    }

    private void validateIfRequired(TaskParameters parameters) throws InvalidTaskParametersException {
        if (this.configuration.isValidation()) {
            LOG.debug("Validating parameters");
            this.validate(parameters);
        } else {
            LOG.info("Validation skipped");
        }
    }

    public void validate(TaskParameters parameters) throws InvalidTaskParametersException {
        Set violations = DefaultValidationContext.getContext().getValidator().validate((Object)parameters, new Class[0]);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder(String.format("Input parameters (%s) are not valid: ", parameters));
            ArrayList<String> reasons = new ArrayList<String>();
            for (ConstraintViolation violation : violations) {
                sb.append(String.format("\"(%s=%s) %s\" ", violation.getPropertyPath(), violation.getInvalidValue(), violation.getMessage()));
                reasons.add(violation.getMessage());
            }
            throw new InvalidTaskParametersException(sb.toString(), reasons);
        }
    }

    private void preExecution(TaskExecutionContext context) {
        context.taskStart();
        ApplicationEventsNotifier.notifyEvent(context.notifiableTaskMetadata()).taskStarted();
    }

    private void postExecution(TaskExecutionContext context) {
        context.taskEnded();
        ApplicationEventsNotifier.notifyEvent(context.notifiableTaskMetadata()).taskCompleted(context.executionTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualExecution(TaskParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        try {
            executionContext.task().before(parameters, executionContext);
            executionContext.task().execute(parameters);
        }
        finally {
            try {
                executionContext.task().after();
            }
            catch (RuntimeException e) {
                LOG.warn("An unexpected error occurred during the execution of the 'after' phase.", (Throwable)e);
            }
        }
    }
}

