/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sejda.commons.util.RequireUtils;

public final class NameGenerationRequest {
    private static final String EXTENSION_KEY = "extension";
    private static final String BOOKMARK_KEY = "bookmark";
    private static final String ORIGINAL_NAME_KEY = "originalName";
    private static final String TEXT_KEY = "text";
    private static final String PAGE_KEY = "page";
    private static final String FILENUMBER_KEY = "fileNumber";
    private final Map<String, Object> values = new HashMap<String, Object>();

    private NameGenerationRequest(String extension) {
        RequireUtils.requireNotBlank((String)extension, (String)"Extension cannot be blank");
        this.setValue(EXTENSION_KEY, extension);
    }

    public static NameGenerationRequest nameRequest() {
        return new NameGenerationRequest("pdf");
    }

    public static NameGenerationRequest nameRequest(String extension) {
        return new NameGenerationRequest(extension);
    }

    public NameGenerationRequest page(int page) {
        this.setValue(PAGE_KEY, page);
        return this;
    }

    public NameGenerationRequest fileNumber(int fileNumber) {
        this.setValue(FILENUMBER_KEY, fileNumber);
        return this;
    }

    public NameGenerationRequest bookmark(String bookmark) {
        this.setValue(BOOKMARK_KEY, StringUtils.trim((String)bookmark));
        return this;
    }

    public NameGenerationRequest originalName(String originalName) {
        RequireUtils.requireNotBlank((String)originalName, (String)"Original name cannot be blank");
        if (originalName.lastIndexOf(46) >= 1) {
            this.setValue(ORIGINAL_NAME_KEY, originalName.substring(0, originalName.lastIndexOf(46)));
        } else {
            this.setValue(ORIGINAL_NAME_KEY, originalName);
        }
        return this;
    }

    public NameGenerationRequest text(String text) {
        this.setValue(TEXT_KEY, text);
        return this;
    }

    public Integer getPage() {
        return this.getValue(PAGE_KEY, Integer.class);
    }

    public Integer getFileNumber() {
        return this.getValue(FILENUMBER_KEY, Integer.class);
    }

    public String getBookmark() {
        return this.getValue(BOOKMARK_KEY, String.class);
    }

    public String getOriginalName() {
        return this.getValue(ORIGINAL_NAME_KEY, String.class);
    }

    public String getExtension() {
        return this.getValue(EXTENSION_KEY, String.class);
    }

    public String getText() {
        return this.getValue(TEXT_KEY, String.class);
    }

    public <T> T getValue(String key, Class<T> type) {
        return Optional.ofNullable(this.values.get(key)).filter(type::isInstance).map(type::cast).orElse(null);
    }

    public void setValue(String key, Object value) {
        RequireUtils.requireNotNullArg((Object)key, (String)"Key cannot be null");
        this.values.put(key, value);
    }
}

