/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.util;

import java.util.Locale;

public class HumanReadableSize {
    public static final long KB = 1000L;
    public static final long MB = 1000000L;

    private HumanReadableSize() {
    }

    public static String toString(long size) {
        return HumanReadableSize.toString(size, false);
    }

    public static String toString(long size, boolean roundUp) {
        String format = roundUp ? "%.0f" : "%.2f";
        String unit = "bytes";
        String unitSize = String.format("%.0f", Float.valueOf(size));
        if (size > 1000000L) {
            unit = "MB";
            unitSize = String.format(format, Float.valueOf((float)size / 1000000.0f));
        } else if (size > 1000L) {
            unit = "KB";
            unitSize = String.format(format, Float.valueOf((float)size / 1000.0f));
        }
        return String.format(Locale.US, "%s %s", unitSize, unit);
    }
}

