/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.eventstudio;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.pdfsam.eventstudio.Annotations;
import org.pdfsam.eventstudio.EventStudio;
import org.pdfsam.eventstudio.Listener;
import org.pdfsam.eventstudio.ReferenceStrength;
import org.pdfsam.eventstudio.Station;
import org.pdfsam.eventstudio.Stations;
import org.pdfsam.eventstudio.Supervisor;
import org.pdfsam.eventstudio.exception.EventStudioException;
import org.pdfsam.eventstudio.util.RequireUtils;
import org.pdfsam.eventstudio.util.StringUtils;

public class DefaultEventStudio
implements EventStudio {
    public static final String HIDDEN_STATION = "hidden.station";
    private Stations stations = new Stations();

    @Override
    public <T> void add(Listener<T> listener, String station, int priority, ReferenceStrength strength) {
        this.stations.getStation(station).add(listener, priority, strength);
    }

    @Override
    public <T> void add(Listener<T> listener, String station) {
        this.add(listener, station, 0, ReferenceStrength.STRONG);
    }

    @Override
    public <T> void add(Class<T> eventClass, Listener<T> listener, String station) {
        this.add(eventClass, listener, station, 0, ReferenceStrength.STRONG);
    }

    @Override
    public <T> void add(Class<T> eventClass, Listener<T> listener, String station, int priority, ReferenceStrength strength) {
        this.stations.getStation(station).add(eventClass, listener, priority, strength);
    }

    @Override
    public void addAnnotatedListeners(Object bean) {
        try {
            Annotations.ReflectiveMetadata metadata = Annotations.process(bean);
            for (Map.Entry<String, List<Annotations.ReflectiveListenerDescriptor>> current : metadata.getDescriptors().entrySet()) {
                String station = StringUtils.defaultString(metadata.getStation(), HIDDEN_STATION);
                this.stations.getStation(StringUtils.defaultString(current.getKey(), station)).addAll(bean, current.getValue());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new EventStudioException("An error occurred processing the input bean", e);
        }
    }

    public <T> void add(Class<T> eventClass, Listener<T> listener, int priority, ReferenceStrength strength) {
        this.add(eventClass, listener, HIDDEN_STATION, priority, strength);
    }

    public <T> void add(Listener<T> listener, int priority, ReferenceStrength strength) {
        this.add(listener, HIDDEN_STATION, priority, strength);
    }

    public <T> void add(Listener<T> listener) {
        this.add(listener, HIDDEN_STATION);
    }

    public <T> void add(Class<T> eventClass, Listener<T> listener) {
        this.add(eventClass, listener, HIDDEN_STATION);
    }

    public void supervisor(Supervisor supervisor) {
        this.supervisor(supervisor, HIDDEN_STATION);
    }

    @Override
    public void supervisor(Supervisor supervisor, String station) {
        RequireUtils.requireNotNull(supervisor);
        this.stations.getStation(station).supervisor(supervisor);
    }

    @Override
    public <T> boolean remove(Listener<T> listener, String station) {
        return this.stations.getStation(station).remove(listener);
    }

    @Override
    public <T> boolean remove(Class<T> eventClass, Listener<T> listener, String station) {
        return this.stations.getStation(station).remove(eventClass, listener);
    }

    public <T> boolean remove(Listener<T> listener) {
        return this.remove(listener, HIDDEN_STATION);
    }

    public <T> boolean remove(Class<T> eventClass, Listener<T> listener) {
        return this.remove(eventClass, listener, HIDDEN_STATION);
    }

    @Override
    public void clear(String station) {
        this.stations.clear(station);
    }

    public void clear() {
        this.stations.clear(HIDDEN_STATION);
    }

    @Override
    public void broadcast(Object event, String station) {
        this.stations.getStation(station).broadcast(event);
    }

    public void broadcast(Object event) {
        this.stations.getStation(HIDDEN_STATION).broadcast(event);
    }

    @Override
    public void broadcastToEveryStation(Object event) {
        for (Station station : this.stations.getStations()) {
            station.broadcast(event);
        }
    }
}

