/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.regex.Pattern;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSVisitor;

public class COSFloat
extends COSNumber {
    private static final Pattern DOTS = Pattern.compile("\\.");
    private static final Pattern EXP_END = Pattern.compile("[e|E]$");
    private static final Pattern NUM1 = Pattern.compile("^(-)([-|+]+)\\d+\\.\\d+");
    private static final Pattern NUM2 = Pattern.compile("^(-)([\\-|+]+)");
    private static final Pattern NUM3 = Pattern.compile("^0\\.0*-\\d+");
    private static final Pattern ZERO = Pattern.compile("^0-(\\.|\\d+)*");
    private static final Pattern MINUS = Pattern.compile("-");
    private float value;
    private String stringValue;

    public COSFloat(float value) {
        this.value = this.coerce(value);
        this.stringValue = this.formatString();
    }

    public COSFloat(String aFloat) throws IOException {
        try {
            float parsedValue = Float.parseFloat((String)aFloat);
            this.value = this.coerce(parsedValue);
            if (parsedValue == this.value) {
                this.stringValue = aFloat;
            }
        }
        catch (NumberFormatException e) {
            try {
                int dot = ((String)aFloat).indexOf(46);
                if (dot != ((String)aFloat).lastIndexOf(46)) {
                    aFloat = ((String)aFloat).substring(0, dot + 1) + DOTS.matcher(((String)aFloat).substring(dot + 1)).replaceAll("0");
                }
                aFloat = EXP_END.matcher((CharSequence)aFloat).replaceAll("");
                this.value = this.coerce(Float.parseFloat((String)aFloat));
            }
            catch (NumberFormatException nfex) {
                try {
                    if (NUM1.matcher((CharSequence)aFloat).matches()) {
                        this.value = this.coerce(Float.parseFloat(NUM2.matcher((CharSequence)aFloat).replaceFirst("-")));
                    } else if (ZERO.matcher((CharSequence)aFloat).matches()) {
                        this.value = 0.0f;
                    } else {
                        RequireUtils.requireIOCondition((boolean)NUM3.matcher((CharSequence)aFloat).matches(), (String)("Expected floating point number but found '" + (String)aFloat + "'"));
                        this.value = this.coerce(Float.parseFloat("-" + MINUS.matcher((CharSequence)aFloat).replaceFirst("")));
                    }
                }
                catch (NumberFormatException e2) {
                    throw new IOException("Error expected floating point number actual='" + (String)aFloat + "'", e2);
                }
            }
        }
        if (Objects.isNull(this.stringValue)) {
            this.stringValue = this.formatString();
        }
    }

    private float coerce(float floatValue) {
        if (floatValue == Float.POSITIVE_INFINITY) {
            return Float.MAX_VALUE;
        }
        if (floatValue == Float.NEGATIVE_INFINITY) {
            return -3.4028235E38f;
        }
        if (Math.abs(floatValue) < Float.MIN_NORMAL) {
            return 0.0f;
        }
        return floatValue;
    }

    private String formatString() {
        String s;
        String string = s = this.value == (float)((long)this.value) ? String.valueOf((long)this.value) : String.valueOf(this.value);
        if (s.indexOf(69) < 0) {
            return s;
        }
        return new BigDecimal(s).stripTrailingZeros().toPlainString();
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof COSFloat)) return false;
        COSFloat cosfloat = (COSFloat)o;
        if (Float.floatToIntBits(cosfloat.value) != Float.floatToIntBits(this.value)) return false;
        return true;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public String toString() {
        return this.stringValue;
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }
}

