/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.sejda.io.SeekableSource;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.input.BaseCOSParser;
import org.sejda.sambox.input.ExistingIndirectCOSObject;
import org.sejda.sambox.input.IndirectObjectsProvider;
import org.sejda.sambox.input.LazyIndirectObjectsProvider;
import org.sejda.sambox.util.CharUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class COSParser
extends BaseCOSParser {
    private static final Logger LOG = LoggerFactory.getLogger(COSParser.class);
    private final IndirectObjectsProvider provider;

    COSParser(SeekableSource source) {
        super(source);
        this.provider = new LazyIndirectObjectsProvider().initializeWith(this);
    }

    COSParser(SeekableSource source, IndirectObjectsProvider provider) {
        super(source);
        this.provider = provider;
    }

    @Override
    public COSBase nextParsedToken() throws IOException {
        this.skipSpaces();
        char c = (char)this.source().peek();
        switch (c) {
            case '<': {
                this.source().read();
                c = (char)this.source().peek();
                this.source().back();
                if (c == '<') {
                    return this.nextDictionary();
                }
                return this.nextHexadecimalString();
            }
            case '[': {
                return this.nextArray();
            }
            case '(': {
                return this.nextLiteralString();
            }
            case '/': {
                return this.nextName();
            }
            case 'n': {
                return this.nextNull();
            }
            case 'f': 
            case 't': {
                return this.nextBoolean();
            }
            case '+': 
            case '-': 
            case '.': {
                return this.nextNumber();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.nextNumberOrIndirectReference();
            }
            case '\uffff': {
                return null;
            }
        }
        String badString = this.readToken();
        if ("endobj".equals(badString) || "endstream".equals(badString) || "obj".equals(badString)) {
            this.source().back((long)badString.getBytes(StandardCharsets.ISO_8859_1).length);
        } else {
            LOG.warn(String.format("Unknown token with value '%s' ending at offset %d", badString, this.position()));
            if (badString.length() <= 0) {
                this.source().read();
            }
        }
        return null;
    }

    public COSBase nextNumberOrIndirectReference() throws IOException {
        String first = this.readNumber();
        long offset = this.position();
        this.skipSpaces();
        if (CharUtils.isDigit(this.source().peek())) {
            String second = this.readIntegerNumber();
            this.skipSpaces();
            if (82 == this.source().read()) {
                try {
                    return new ExistingIndirectCOSObject(Long.parseLong(first), Integer.parseInt(second), this.provider);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException(String.format("Unable to parse an object indirect reference with object number '%s' and generation number '%s'", first, second), nfe);
                }
            }
        }
        this.position(offset);
        return COSNumber.get(first);
    }

    public IndirectObjectsProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

