/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.input.SourceReader;
import org.sejda.sambox.xref.Xref;
import org.sejda.sambox.xref.XrefEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectsFullScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectsFullScanner.class);
    private final Matcher matcher = Pattern.compile("(\\d+)[\\s]+(\\d+)[\\s]+obj").matcher("");
    private Xref xref = new Xref();
    private SourceReader reader;
    private boolean scanned = false;

    ObjectsFullScanner(SourceReader reader) {
        RequireUtils.requireNotNullArg((Object)reader, (String)"Cannot read from a null reader");
        this.reader = reader;
    }

    private void scan() {
        LOG.info("Performing full scan to retrieve objects");
        try {
            long savedPos = this.reader.position();
            this.reader.position(0L);
            this.reader.skipSpaces();
            while (this.reader.source().peek() != -1) {
                long offset = this.reader.position();
                this.addEntryIfObjectDefinition(offset, this.reader.readLine());
                this.reader.skipSpaces();
            }
            this.reader.position(savedPos);
        }
        catch (IOException e) {
            LOG.error("An error occurred performing a full scan of the document", (Throwable)e);
        }
    }

    private void addEntryIfObjectDefinition(long offset, String line) throws IOException {
        boolean found = false;
        if (line.contains("obj")) {
            this.matcher.reset(line);
            while (this.matcher.find()) {
                long entryOffset = offset + (long)this.matcher.start();
                this.xref.add(XrefEntry.inUseEntry(Long.parseUnsignedLong(this.matcher.group(1)), entryOffset, Integer.parseUnsignedInt(this.matcher.group(2))));
                this.onObjectDefinitionLine(entryOffset, line);
                found = true;
            }
        }
        if (!found) {
            this.onNonObjectDefinitionLine(offset, line);
        }
    }

    protected void onNonObjectDefinitionLine(long originalOffset, String line) throws IOException {
    }

    protected void onObjectDefinitionLine(long originalOffset, String line) throws IOException {
    }

    Xref entries() {
        if (!this.scanned) {
            this.scanned = true;
            this.scan();
        }
        return this.xref;
    }
}

