/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.merge;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ComboItem;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.merge.MergeParametersBuilder;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.model.outline.OutlinePolicy;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.model.scale.PageNormalizationPolicy;
import org.sejda.model.toc.ToCPolicy;

class MergeOptionsPane
extends VBox
implements TaskParametersBuildStep<MergeParametersBuilder>,
RestorableView,
ResettableView {
    private final ComboBox<ComboItem<AcroFormPolicy>> acroForms = new ComboBox();
    private final CheckBox blankIfOdd;
    private final CheckBox footer;
    private final ComboBox<ComboItem<PageNormalizationPolicy>> pageNormalization = new ComboBox();
    private final ComboBox<ComboItem<OutlinePolicy>> outline = new ComboBox();
    private final ComboBox<ComboItem<ToCPolicy>> toc = new ComboBox();

    MergeOptionsPane() {
        super(5.0);
        this.blankIfOdd = new CheckBox(I18nContext.i18n().tr("Add a blank page if page number is odd"));
        this.blankIfOdd.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Adds a blank page after each merged document if the document has an odd number of pages")));
        this.blankIfOdd.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.blankIfOdd.setId("blankIfOddCheck");
        this.footer = new CheckBox(I18nContext.i18n().tr("Add a footer"));
        this.footer.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Adds a page footer with the name of the file the page belonged to.")));
        this.footer.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.footer.setId("footerCheck");
        GridPane options = new GridPane();
        this.pageNormalization.getItems().add((Object)new ComboItem((Object)PageNormalizationPolicy.NONE, I18nContext.i18n().tr("None")));
        this.pageNormalization.getItems().add((Object)new ComboItem((Object)PageNormalizationPolicy.SAME_WIDTH, I18nContext.i18n().tr("Same width as first page")));
        this.pageNormalization.getItems().add((Object)new ComboItem((Object)PageNormalizationPolicy.SAME_WIDTH_ORIENTATION_BASED, I18nContext.i18n().tr("Same width as first page (based on page orientation)")));
        this.pageNormalization.setId("normalizeCheck");
        options.add((Node)new Label(I18nContext.i18n().tr("Pages normalization:")), 0, 0);
        this.pageNormalization.setMaxWidth(Double.POSITIVE_INFINITY);
        options.add(this.pageNormalization, 1, 0);
        options.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set whether pages should be resized to all have the same width as the first one")), 2, 0);
        this.acroForms.getItems().add((Object)new ComboItem((Object)AcroFormPolicy.MERGE_RENAMING_EXISTING_FIELDS, I18nContext.i18n().tr("Merge renaming existing fields")));
        this.acroForms.getItems().add((Object)new ComboItem((Object)AcroFormPolicy.MERGE, I18nContext.i18n().tr("Merge fields")));
        this.acroForms.getItems().add((Object)new ComboItem((Object)AcroFormPolicy.FLATTEN, I18nContext.i18n().tr("Flatten")));
        this.acroForms.getItems().add((Object)new ComboItem((Object)AcroFormPolicy.DISCARD, I18nContext.i18n().tr("Discard forms")));
        this.acroForms.setId("acroFormsCombo");
        options.add((Node)new Label(I18nContext.i18n().tr("Interactive forms (AcroForms):")), 0, 1);
        this.acroForms.setMaxWidth(Double.POSITIVE_INFINITY);
        options.add(this.acroForms, 1, 1);
        options.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("What to do in case one or more input documents contain Acro Forms")), 2, 1);
        this.outline.getItems().add((Object)new ComboItem((Object)OutlinePolicy.RETAIN, I18nContext.i18n().tr("Retain bookmarks")));
        this.outline.getItems().add((Object)new ComboItem((Object)OutlinePolicy.DISCARD, I18nContext.i18n().tr("Discard bookmarks")));
        this.outline.getItems().add((Object)new ComboItem((Object)OutlinePolicy.ONE_ENTRY_EACH_DOC, I18nContext.i18n().tr("Create one entry for each merged document")));
        this.outline.getItems().add((Object)new ComboItem((Object)OutlinePolicy.RETAIN_AS_ONE_ENTRY, I18nContext.i18n().tr("Retain bookmarks as one entry for each merged document")));
        this.outline.setId("outlineCombo");
        options.add((Node)new Label(I18nContext.i18n().tr("Bookmarks handling:")), 0, 2);
        this.outline.setMaxWidth(Double.POSITIVE_INFINITY);
        options.add(this.outline, 1, 2);
        options.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("What to do in case one or more input documents contain bookmarks")), 2, 2);
        this.toc.getItems().add((Object)new ComboItem((Object)ToCPolicy.NONE, I18nContext.i18n().tr("Don't generate")));
        this.toc.getItems().add((Object)new ComboItem((Object)ToCPolicy.FILE_NAMES, I18nContext.i18n().tr("Generate from file names")));
        this.toc.getItems().add((Object)new ComboItem((Object)ToCPolicy.DOC_TITLES, I18nContext.i18n().tr("Generate from documents titles")));
        this.toc.setId("tocCombo");
        options.add((Node)new Label(I18nContext.i18n().tr("Table of contents:")), 0, 3);
        this.toc.setMaxWidth(Double.POSITIVE_INFINITY);
        options.add(this.toc, 1, 3);
        options.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("Set if a table of contents should be added to the generated PDF document")), 2, 3);
        options.getStyleClass().addAll((Object[])Style.GRID.css());
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.resetView();
        this.getChildren().addAll((Object[])new Node[]{this.blankIfOdd, this.footer, options});
    }

    public void resetView() {
        this.blankIfOdd.setSelected(false);
        this.footer.setSelected(false);
        this.pageNormalization.getSelectionModel().selectFirst();
        this.acroForms.getSelectionModel().selectFirst();
        this.outline.getSelectionModel().selectFirst();
        this.toc.getSelectionModel().selectFirst();
    }

    public void apply(MergeParametersBuilder builder, Consumer<String> onError) {
        builder.outlinePolicy((OutlinePolicy)((ComboItem)this.outline.getSelectionModel().getSelectedItem()).key());
        builder.acroFormsPolicy((AcroFormPolicy)((ComboItem)this.acroForms.getSelectionModel().getSelectedItem()).key());
        builder.tocPolicy((ToCPolicy)((ComboItem)this.toc.getSelectionModel().getSelectedItem()).key());
        builder.blankPageIfOdd(this.blankIfOdd.isSelected());
        builder.footer(this.footer.isSelected());
        builder.pageNormalizationPolicy((PageNormalizationPolicy)((ComboItem)this.pageNormalization.getSelectionModel().getSelectedItem()).key());
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("outline", Optional.ofNullable((ComboItem)this.outline.getSelectionModel().getSelectedItem()).map(i -> ((OutlinePolicy)i.key()).toString()).orElse(""));
        data.put("acroForms", Optional.ofNullable((ComboItem)this.acroForms.getSelectionModel().getSelectedItem()).map(i -> ((AcroFormPolicy)i.key()).toString()).orElse(""));
        data.put("toc", Optional.ofNullable((ComboItem)this.toc.getSelectionModel().getSelectedItem()).map(i -> ((ToCPolicy)i.key()).toString()).orElse(""));
        data.put("blankIfOdd", Boolean.toString(this.blankIfOdd.isSelected()));
        data.put("footer", Boolean.toString(this.footer.isSelected()));
        data.put("pageNormalization", Optional.ofNullable((ComboItem)this.pageNormalization.getSelectionModel().getSelectedItem()).map(i -> ((PageNormalizationPolicy)i.key()).toString()).orElse(""));
    }

    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("outline")).map(OutlinePolicy::valueOf).flatMap(key -> this.outline.getItems().stream().filter(i -> ((OutlinePolicy)i.key()).equals(key)).findFirst()).ifPresent(arg_0 -> ((SingleSelectionModel)this.outline.getSelectionModel()).select(arg_0));
        Optional.ofNullable(data.get("acroForms")).map(AcroFormPolicy::valueOf).flatMap(key -> this.acroForms.getItems().stream().filter(i -> ((AcroFormPolicy)i.key()).equals(key)).findFirst()).ifPresent(arg_0 -> ((SingleSelectionModel)this.acroForms.getSelectionModel()).select(arg_0));
        Optional.ofNullable(data.get("toc")).map(ToCPolicy::valueOf).flatMap(key -> this.toc.getItems().stream().filter(i -> ((ToCPolicy)i.key()).equals(key)).findFirst()).ifPresent(arg_0 -> ((SingleSelectionModel)this.toc.getSelectionModel()).select(arg_0));
        PageNormalizationPolicy normalization = Optional.ofNullable(data.get("pageNormalization")).map(PageNormalizationPolicy::valueOf).orElseGet(() -> {
            if (Boolean.parseBoolean((String)data.get("normalize"))) {
                return PageNormalizationPolicy.SAME_WIDTH_ORIENTATION_BASED;
            }
            return PageNormalizationPolicy.NONE;
        });
        this.pageNormalization.getItems().stream().filter(i -> ((PageNormalizationPolicy)i.key()).equals((Object)normalization)).findFirst().ifPresent(arg_0 -> ((SingleSelectionModel)this.pageNormalization.getSelectionModel()).select(arg_0));
        this.blankIfOdd.setSelected(Boolean.parseBoolean(data.get("blankIfOdd")));
        this.footer.setSelected(Boolean.parseBoolean(data.get("footer")));
    }
}

