/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.merge;

import java.util.Set;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.SingleOutputTaskParametersBuilder;
import org.sejda.commons.collection.NullSafeSet;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.outline.OutlinePolicy;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.parameter.MergeParameters;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.model.scale.PageNormalizationPolicy;
import org.sejda.model.toc.ToCPolicy;

class MergeParametersBuilder
extends AbstractPdfOutputParametersBuilder<MergeParameters>
implements SingleOutputTaskParametersBuilder<MergeParameters> {
    private final Set<PdfMergeInput> inputs = new NullSafeSet();
    private OutlinePolicy outlinePolicy = OutlinePolicy.RETAIN;
    private boolean blankIfOdd;
    private boolean footer;
    private PageNormalizationPolicy pageNormalizationPolicy = PageNormalizationPolicy.NONE;
    private AcroFormPolicy formsPolicy = AcroFormPolicy.MERGE_RENAMING_EXISTING_FIELDS;
    private ToCPolicy tocPolicy = ToCPolicy.NONE;
    private FileTaskOutput output;

    MergeParametersBuilder() {
    }

    void addInput(PdfMergeInput input) {
        this.inputs.add(input);
    }

    boolean hasInput() {
        return !this.inputs.isEmpty();
    }

    void outlinePolicy(OutlinePolicy outlinePolicy) {
        this.outlinePolicy = outlinePolicy;
    }

    void blankPageIfOdd(boolean blankIfOdd) {
        this.blankIfOdd = blankIfOdd;
    }

    void footer(boolean footer) {
        this.footer = footer;
    }

    void pageNormalizationPolicy(PageNormalizationPolicy pageNormalizationPolicy) {
        this.pageNormalizationPolicy = pageNormalizationPolicy;
    }

    void acroFormsPolicy(AcroFormPolicy formsPolicy) {
        this.formsPolicy = formsPolicy;
    }

    void tocPolicy(ToCPolicy tocPolicy) {
        this.tocPolicy = tocPolicy;
    }

    public void output(FileTaskOutput output) {
        this.output = output;
    }

    public MergeParameters build() {
        MergeParameters params = new MergeParameters();
        params.setCompress(this.isCompress());
        params.setExistingOutputPolicy(this.existingOutput());
        params.setVersion(this.getVersion());
        this.inputs.forEach(arg_0 -> ((MergeParameters)params).addInput(arg_0));
        params.setOutlinePolicy(this.outlinePolicy);
        params.setBlankPageIfOdd(this.blankIfOdd);
        params.setAcroFormPolicy(this.formsPolicy);
        params.setTableOfContentsPolicy(this.tocPolicy);
        params.setOutput((SingleTaskOutput)this.output);
        params.setFilenameFooter(this.footer);
        params.setPageNormalizationPolicy(this.pageNormalizationPolicy);
        return params;
    }
}

