/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.merge;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.tools.merge.MergeParametersBuilder;
import org.pdfsam.ui.components.selection.multiple.FileColumn;
import org.pdfsam.ui.components.selection.multiple.IntColumn;
import org.pdfsam.ui.components.selection.multiple.LoadingColumn;
import org.pdfsam.ui.components.selection.multiple.LongColumn;
import org.pdfsam.ui.components.selection.multiple.MultipleSelectionPane;
import org.pdfsam.ui.components.selection.multiple.PageRangesColumn;
import org.pdfsam.ui.components.selection.multiple.SelectedPagesColumn;
import org.pdfsam.ui.components.selection.multiple.TableColumnProvider;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.input.PdfSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeSelectionPane
extends MultipleSelectionPane
implements TaskParametersBuildStep<MergeParametersBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(MergeSelectionPane.class);

    public MergeSelectionPane(String ownerModule) {
        super(ownerModule, true, true, new TableColumnProvider[]{new LoadingColumn(ownerModule), FileColumn.NAME, LongColumn.SIZE, IntColumn.PAGES, new PageRangesColumn(I18nContext.i18n().tr("Double click to set pages you want to merge (ex: 2 or 5-23 or 2,5-7,12-)")), new SelectedPagesColumn(), LongColumn.LAST_MODIFIED});
        this.showTotalPagesLabel();
    }

    public void apply(MergeParametersBuilder builder, Consumer<String> onError) {
        try {
            this.table().getItems().stream().filter(s -> !Objects.equals("0", StringUtils.trim((String)s.pageSelection.get()))).map(i -> new PdfMergeInput((PdfSource)i.descriptor().toPdfFileSource(), i.toPageRangeSet())).forEach(builder::addInput);
            if (!builder.hasInput()) {
                onError.accept(I18nContext.i18n().tr("No PDF document has been selected"));
            }
        }
        catch (ConversionException e) {
            LOG.error(e.getMessage());
            onError.accept(e.getMessage());
        }
    }
}

