/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.merge;

import jakarta.inject.Named;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.injector.Provides;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.tool.ToolDescriptor;
import org.pdfsam.model.tool.ToolDescriptorBuilder;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.tool.ToolPriority;
import org.pdfsam.tools.merge.MergeToolPanel;
import org.pdfsam.ui.components.io.BrowsableField;
import org.pdfsam.ui.components.io.BrowsablePdfOutputField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.tool.Footer;
import org.pdfsam.ui.components.tool.OpenButton;
import org.pdfsam.ui.components.tool.RunButton;

@Auto
public class MergeTool
implements Tool {
    static final String TOOL_ID = "merge";
    private final ToolDescriptor descriptor = ToolDescriptorBuilder.builder().category(ToolCategory.MERGE).inputTypes(new ToolInputOutputType[]{ToolInputOutputType.MULTIPLE_PDF}).name(I18nContext.i18n().tr("Merge")).description(I18nContext.i18n().tr("Merge multiple PDF documents or subsections of them.")).priority(ToolPriority.HIGH.getPriority()).supportURL("https://pdfsam.org/pdf-merge/").build();

    public ToolDescriptor descriptor() {
        return this.descriptor;
    }

    public Pane panel() {
        return (Pane)ApplicationContext.app().instance(MergeToolPanel.class);
    }

    public String id() {
        return TOOL_ID;
    }

    public Node graphic() {
        FontIcon icon = new FontIcon((Ikon)UniconsLine.FILES_LANDSCAPES_ALT);
        icon.getStyleClass().addAll((Object[])new String[]{this.descriptor().category().styleClass(), "tool-icon"});
        return icon;
    }

    public static class ModuleConfig {
        @Provides
        @Named(value="mergefield")
        public BrowsablePdfOutputField destinationFileField() {
            return new BrowsablePdfOutputField();
        }

        @Provides
        @Named(value="mergepane")
        public PdfDestinationPane destinationPane(@Named(value="mergefield") BrowsablePdfOutputField outputField) {
            return new PdfDestinationPane((BrowsableField)outputField, MergeTool.TOOL_ID, new PdfDestinationPane.DestinationPanelFields[0]);
        }

        @Provides
        @Named(value="mergefooter")
        public Footer footer(RunButton runButton, @Named(value="mergeopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, MergeTool.TOOL_ID);
        }

        @Provides
        @Named(value="mergeopenButton")
        public OpenButton openButton() {
            return new OpenButton(MergeTool.TOOL_ID, ToolInputOutputType.SINGLE_PDF);
        }
    }
}

