/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.home;

import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

class HomeTile
extends StackPane {
    private static final PseudoClass PSEUDO_CLASS_ARMED = PseudoClass.getPseudoClass((String)"armed");
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private final Button invisibleButton = new Button();

    public HomeTile(String title, String description, Node graphic, String categoryClass) {
        this.getStyleClass().addAll((Object[])new String[]{"home-tile"});
        Label top = new Label(title);
        top.getStyleClass().add((Object)"title");
        if (Objects.nonNull(graphic)) {
            top.setGraphic(graphic);
        }
        Label bottom = new Label(description);
        bottom.getStyleClass().add((Object)"description");
        VBox vbox = new VBox(new Node[]{top, bottom});
        vbox.getStyleClass().add((Object)"right");
        this.invisibleButton.getStyleClass().add((Object)"home-tile-invisible-button");
        this.invisibleButton.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Region categoryMark = new Region();
        categoryMark.getStyleClass().addAll((Object[])new String[]{"category-mark", categoryClass});
        categoryMark.prefHeightProperty().bind((ObservableValue)vbox.heightProperty());
        HBox hbox = new HBox(new Node[]{categoryMark, vbox});
        this.invisibleButton.prefHeightProperty().bind((ObservableValue)hbox.heightProperty());
        this.invisibleButton.prefWidthProperty().bind((ObservableValue)hbox.widthProperty());
        this.invisibleButton.setFocusTraversable(true);
        this.invisibleButton.focusedProperty().addListener((v, o, n) -> this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, (boolean)n));
        this.invisibleButton.armedProperty().addListener((v, o, n) -> this.pseudoClassStateChanged(PSEUDO_CLASS_ARMED, (boolean)n));
        this.getChildren().addAll((Object[])new Node[]{hbox, this.invisibleButton});
    }

    public final boolean isArmed() {
        return this.invisibleButton.armedProperty().get();
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.invisibleButton.setOnAction(eventHandler);
    }

    void addBottomPanel(Region pane) {
        StackPane.setAlignment((Node)pane, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setMargin((Node)pane, (Insets)new Insets(4.0));
        this.getChildren().add((Object)pane);
    }
}

