/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.log;

import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import org.pdfsam.core.io.Choosers;
import org.pdfsam.core.io.FileChooserWithWorkingDirectory;
import org.pdfsam.core.support.io.ObjectCollectionWriter;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.content.log.LogListView;
import org.pdfsam.gui.components.content.log.LogMessage;
import org.pdfsam.gui.components.content.log.LogPaneToolbar;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.log.ClearLogRequest;
import org.pdfsam.model.log.SaveLogRequest;

public class LogPane
extends BorderPane {
    private final LogListView logView;

    @Inject
    public LogPane(LogListView view, LogPaneToolbar toolbar) {
        this.logView = view;
        this.getStyleClass().addAll((Object[])new String[]{"logs-pane", "spaced-container"});
        this.setCenter((Node)this.logView);
        this.setTop((Node)toolbar);
        MenuItem copyItem = new MenuItem(I18nContext.i18n().tr("Copy"));
        copyItem.setId("copyLogMenuItem");
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copyItem.setOnAction(e -> this.copyLog((Collection<LogMessage>)this.logView.getSelectionModel().getSelectedItems()));
        copyItem.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.logView.getSelectionModel().getSelectedItems()));
        MenuItem clearItem = new MenuItem(I18nContext.i18n().tr("Clear"));
        clearItem.setId("clearLogMenuItem");
        clearItem.setOnAction(e -> this.clearLog(null));
        clearItem.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.logView.getItems()));
        MenuItem selectAllItem = new MenuItem(I18nContext.i18n().tr("Select all"));
        selectAllItem.setId("selectAllLogMenuItem");
        selectAllItem.setOnAction(e -> this.logView.getSelectionModel().selectAll());
        selectAllItem.disableProperty().bind((ObservableValue)clearItem.disableProperty());
        MenuItem saveItem = new MenuItem(I18nContext.i18n().tr("Save log"));
        saveItem.setId("saveLogMenuItem");
        saveItem.setOnAction(e -> this.saveLog(null));
        saveItem.disableProperty().bind((ObservableValue)clearItem.disableProperty());
        this.logView.setContextMenu(new ContextMenu(new MenuItem[]{copyItem, clearItem, selectAllItem, new SeparatorMenuItem(), saveItem}));
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void saveLog(SaveLogRequest request) {
        FileChooserWithWorkingDirectory fileChooser = Choosers.fileChooser((String)I18nContext.i18n().tr("Select where to save the log file"), (FileType[])new FileType[]{FileType.LOG});
        fileChooser.setInitialFileName("PDFsam.log");
        Path saveTo = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (Objects.nonNull(saveTo)) {
            ObjectCollectionWriter.writeContent((Collection)this.logView.getItems()).to(saveTo);
        }
    }

    @EventListener
    public void clearLog(ClearLogRequest request) {
        this.logView.getItems().clear();
    }

    public void copyLog(Collection<LogMessage> selected) {
        if (!selected.isEmpty()) {
            ClipboardContent content = new ClipboardContent();
            ObjectCollectionWriter.writeContent(selected).to(content);
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }
}

