/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.log;

import jakarta.inject.Inject;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.gui.components.content.log.LogListView;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.log.ClearLogRequest;
import org.pdfsam.model.log.SaveLogRequest;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.pdfsam.ui.components.support.Style;

class LogPaneToolbar
extends ToolBar {
    @Inject
    public LogPaneToolbar(LogListView logView) {
        ClearButton clearItem = new ClearButton();
        clearItem.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)logView.getItems()));
        SaveButton saveItem = new SaveButton();
        saveItem.disableProperty().bind((ObservableValue)clearItem.disableProperty());
        CloseButton closeItem = new CloseButton(this);
        this.getItems().addAll((Object[])new Node[]{saveItem, clearItem, closeItem});
        this.getStyleClass().add((Object)"log-tool-bar");
    }

    static class ClearButton
    extends Button {
        public ClearButton() {
            this.setTooltip(new Tooltip(I18nContext.i18n().tr("Removes all the log messages")));
            this.setText(I18nContext.i18n().tr("_Clear"));
            this.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new ClearLogRequest()));
            this.getStyleClass().addAll((Object[])Style.BUTTON.css());
            this.getStyleClass().addAll((Object[])Style.TOOLBAR_BUTTON.css());
        }
    }

    static class SaveButton
    extends Button {
        public SaveButton() {
            this.setText(I18nContext.i18n().tr("_Save"));
            this.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)new SaveLogRequest()));
            this.getStyleClass().addAll((Object[])Style.BUTTON.css());
            this.getStyleClass().addAll((Object[])Style.TOOLBAR_BUTTON.css());
        }
    }

    class CloseButton
    extends Button {
        public CloseButton(LogPaneToolbar this$0) {
            this.setText(I18nContext.i18n().tr("C_lose"));
            ApplicationContext.app().runtimeState().activeTool().subscribe(t -> Platform.runLater(() -> {
                this.setVisible(t.isPresent());
                t.map(Tool::id).map(SetActiveContentItemRequest::new).ifPresentOrElse(a -> this.setOnAction(e -> StaticStudio.eventStudio().broadcast(a)), () -> this.setOnAction(null));
            }));
            this.getStyleClass().addAll((Object[])Style.BUTTON.css());
            this.getStyleClass().addAll((Object[])Style.TOOLBAR_BUTTON.css());
        }
    }
}

