/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.news;

import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.content.news.News;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.news.HideNewsPanelRequest;
import org.pdfsam.model.news.LatestNewsResponse;
import org.pdfsam.ui.components.support.Style;

public class NewsPanel
extends VBox {
    private final VBox newsPanel = new VBox();
    final ScrollPane scroll = new ScrollPane((Node)this.newsPanel);

    public NewsPanel() {
        this.getStyleClass().add((Object)"news-panel");
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.newsPanel.getStyleClass().add((Object)"news-panel-content");
        Button closeButton = new Button("", (Node)FontIcon.of((Ikon)UniconsLine.TIMES));
        closeButton.getStyleClass().addAll((Object[])new String[]{"close-button"});
        closeButton.setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)HideNewsPanelRequest.INSTANCE));
        Label titleLabel = new Label(I18nContext.i18n().tr("What's new"));
        titleLabel.setPrefWidth(2.147483647E9);
        titleLabel.getStyleClass().add((Object)"news-panel-title");
        StackPane top = new StackPane(new Node[]{titleLabel, closeButton});
        top.setAlignment(Pos.TOP_RIGHT);
        this.scroll.getStyleClass().add((Object)"scrollable-news");
        this.scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scroll.setFitToHeight(true);
        this.scroll.setFitToWidth(true);
        this.getChildren().addAll((Object[])new Node[]{top, this.scroll});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onLatestNews(LatestNewsResponse e) {
        Platform.runLater(() -> this.newsPanel.getChildren().addAll(e.latestNews().stream().map(News::new).toList()));
    }
}

