/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import org.pdfsam.gui.components.content.preference.PreferenceCheckBox;
import org.pdfsam.gui.components.content.preference.PreferenceComboBox;
import org.pdfsam.gui.components.content.preference.PreferencePrefixField;
import org.pdfsam.gui.components.content.preference.PreferenceRadioButton;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ComboItem;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.model.pdf.PdfVersion;

class PreferenceOutputPane
extends GridPane {
    @Inject
    public PreferenceOutputPane(@Named(value="smartRadio") PreferenceRadioButton smartRadio, @Named(value="compressionEnabled") PreferenceCheckBox compressionEnabled, @Named(value="overwriteOutput") PreferenceCheckBox overwriteOutput, @Named(value="discardBookmarks") PreferenceCheckBox discardBookmarks, @Named(value="pdfVersionCombo") PreferenceComboBox<ComboItem<PdfVersion>> pdfVersionCombo, @Named(value="prefixField") PreferencePrefixField prefixField) {
        this.add((Node)new Label(I18nContext.i18n().tr("Default PDF version:")), 0, 1);
        PreferenceOutputPane.setFillWidth(pdfVersionCombo, (Boolean)true);
        pdfVersionCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        this.add((Node)pdfVersionCombo, 1, 1);
        this.add((Node)Views.helpIcon((String)I18nContext.i18n().tr("Default PDF version for generated PDF files")), 2, 1);
        ToggleGroup group = new ToggleGroup();
        RadioButton manualRadio = new RadioButton(I18nContext.i18n().tr("Manually selected"));
        manualRadio.setToggleGroup(group);
        manualRadio.getStyleClass().addAll((Object[])Style.VITEM.css());
        manualRadio.setId("manualRadio");
        this.add((Node)manualRadio, 0, 2, 3, 1);
        smartRadio.getStyleClass().addAll((Object[])Style.VITEM.css());
        smartRadio.setToggleGroup(group);
        smartRadio.setGraphic((Node)Views.helpIcon((String)I18nContext.i18n().tr("Automatically set the destination directory to the selected PDF document directory")));
        smartRadio.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.add((Node)smartRadio, 0, 3, 3, 1);
        if (Objects.isNull(group.getSelectedToggle())) {
            group.selectToggle((Toggle)manualRadio);
        }
        this.add((Node)compressionEnabled, 0, 4, 3, 1);
        this.add((Node)overwriteOutput, 0, 5, 3, 1);
        this.add((Node)discardBookmarks, 0, 6, 3, 1);
        this.add((Node)new Label(I18nContext.i18n().tr("Default prefix:")), 0, 7);
        PreferenceOutputPane.setFillWidth((Node)prefixField, (Boolean)true);
        prefixField.setMaxWidth(Double.POSITIVE_INFINITY);
        this.add((Node)prefixField, 1, 7);
        Text helpIcon = Views.helpIcon((String)"%s.\n%s\n%s\n".formatted(I18nContext.i18n().tr("Default prefix for output file names, used in tools that generate multiple files"), I18nContext.i18n().tr("Some special keywords are replaced with runtime values."), I18nContext.i18n().tr("Right click to add these keywords.")));
        this.add((Node)helpIcon, 2, 7);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.GRID.css());
    }
}

