/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.gui.components.content.preference.PreferenceBrowsableFileField;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferenceSetterOnValidState
implements ChangeListener<FXValidationSupport.ValidationState> {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceBrowsableFileField.class);
    private final StringPersistentProperty property;
    private final ValidableTextField textField;
    private final ApplicationContext context;

    PreferenceSetterOnValidState(StringPersistentProperty property, ValidableTextField textField, ApplicationContext context) {
        RequireUtils.requireNotNullArg((Object)property, (String)"Preference cannot be null");
        RequireUtils.requireNotNullArg((Object)textField, (String)"TextField cannot be null");
        this.textField = textField;
        this.property = property;
        this.context = context;
    }

    public void changed(ObservableValue<? extends FXValidationSupport.ValidationState> observable, FXValidationSupport.ValidationState oldValue, FXValidationSupport.ValidationState newValue) {
        if (newValue == FXValidationSupport.ValidationState.VALID) {
            this.context.persistentSettings().set(this.property, this.textField.getText());
            LOG.trace("Preference {} set to {}", (Object)this.property, (Object)this.textField.getText());
        }
    }
}

