/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.dialog;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.gui.components.dialog.ConfirmationDialogContent;
import org.pdfsam.gui.components.dialog.DialogStyle;
import org.pdfsam.ui.components.support.Style;
import org.sejda.model.output.ExistingOutputPolicy;

public class OverwriteConfirmationDialog
extends Stage {
    private final ConfirmationDialogContent dialogContent;
    private Optional<ExistingOutputPolicy> response = Optional.empty();
    private final HBox buttons = new HBox();

    @Inject
    public OverwriteConfirmationDialog(@Named(value="primaryStage") Stage stage) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initStyle(StageStyle.UTILITY);
        this.initOwner((Window)stage);
        this.dialogContent = new ConfirmationDialogContent(DialogStyle.WARNING.icon);
        VBox containerPane = new VBox();
        containerPane.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.getStyleClass().addAll((Object[])new String[]{"-pdfsam-dialog", DialogStyle.WARNING.style});
        this.buttons.getStyleClass().add((Object)"-pdfsam-dialog-buttons");
        containerPane.getChildren().addAll((Object[])new Node[]{this.dialogContent, this.buttons});
        Scene scene = new Scene((Parent)containerPane);
        this.setScene(scene);
        ApplicationContext.app().registerScene(scene);
        Platform.runLater(() -> {
            scene.getWindow().sizeToScene();
            this.setResizable(false);
        });
        this.setOnShown(e -> this.requestFocus());
    }

    OverwriteConfirmationDialog init() {
        this.response = Optional.empty();
        this.buttons.getChildren().clear();
        return this;
    }

    OverwriteConfirmationDialog title(String title) {
        this.setTitle(title);
        return this;
    }

    OverwriteConfirmationDialog messageTitle(String title) {
        this.dialogContent.messageTitle(title);
        return this;
    }

    OverwriteConfirmationDialog messageContent(String title) {
        this.dialogContent.messageContent(title);
        return this;
    }

    OverwriteConfirmationDialog buttons(Button ... buttons) {
        this.buttons.getChildren().setAll((Object[])buttons);
        return this;
    }

    public Optional<ExistingOutputPolicy> response() {
        this.showAndWait();
        return this.response;
    }

    public Button button(String text, ExistingOutputPolicy response) {
        Button button = new Button(text);
        button.getStyleClass().addAll((Object[])Style.BUTTON.css());
        button.setOnAction(e -> {
            this.response = Optional.ofNullable(response);
            this.hide();
        });
        return button;
    }

    public Button defaultButton(String text, ExistingOutputPolicy response) {
        Button button = this.button(text, response);
        button.setDefaultButton(true);
        return button;
    }

    public Button cancelButton(String text) {
        Button button = this.button(text, null);
        button.setCancelButton(true);
        return button;
    }
}

