/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.info;

import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import org.pdfsam.i18n.I18nContext;

class BaseInfoTab
extends Tab {
    private final GridPane grid = new GridPane();

    BaseInfoTab() {
        this.setClosable(false);
        this.grid.getStyleClass().add((Object)"info-props");
        this.grid.setAlignment(Pos.TOP_CENTER);
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setPercentWidth(25.0);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setPercentWidth(75.0);
        this.grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        ScrollPane scroll = new ScrollPane((Node)this.grid);
        scroll.setFitToHeight(true);
        scroll.setFitToWidth(true);
        this.setContent((Node)scroll);
    }

    protected GridPane grid() {
        return this.grid;
    }

    protected static Label createTitleLabel(String text) {
        Label ret = new Label(I18nContext.i18n().tr(text) + ":");
        ret.getStyleClass().add((Object)"info-property");
        GridPane.setHalignment((Node)ret, (HPos)HPos.RIGHT);
        GridPane.setValignment((Node)ret, (VPos)VPos.TOP);
        return ret;
    }

    protected static Label createValueLabel() {
        Label ret = new Label();
        ret.getStyleClass().add((Object)"info-property-value");
        ret.setWrapText(true);
        return ret;
    }
}

