/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.notification;

import jakarta.inject.Inject;
import java.nio.file.AccessDeniedException;
import java.security.SecureRandom;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.SVGPath;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.AppBrand;
import org.pdfsam.core.BrandableProperty;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.notification.NotificationsContainer;
import org.pdfsam.gui.components.notification.RemoveNotificationRequest;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.news.NewImportantNewsEvent;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.pdfsam.model.update.NoUpdateAvailable;
import org.pdfsam.model.update.UpdateAvailableEvent;
import org.pdfsam.service.tool.UsageService;
import org.pdfsam.ui.components.commons.UrlButton;
import org.pdfsam.ui.components.notification.AddNotificationRequest;
import org.pdfsam.ui.components.notification.NotificationType;
import org.pdfsam.ui.components.support.Style;
import org.sejda.model.exception.InvalidTaskParametersException;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

@Auto
public class NotificationsController {
    private static final int TIMES_BEFORE_DONATION_NOTICE = 5;
    private final NotificationsContainer container;
    private final UsageService service;
    private final AppBrand appBrand;
    private final SecureRandom random = new SecureRandom();

    @Inject
    NotificationsController(NotificationsContainer container, UsageService service, AppBrand appBrand) {
        this.container = container;
        this.service = service;
        this.appBrand = appBrand;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onAddRequest(AddNotificationRequest event) {
        this.container.addNotification(event.title(), (Node)this.buildLabel(event.message(), event.type()));
    }

    private Label buildLabel(String message, NotificationType type) {
        Label textLabel = new Label(message);
        textLabel.getStyleClass().add((Object)"notification-text");
        if (type != null) {
            textLabel.getStyleClass().add((Object)type.getStyleClass());
            textLabel.setGraphic(type.getGraphic());
        }
        return textLabel;
    }

    @EventListener
    public void onTaskFailed(TaskExecutionFailedEvent e) {
        Throwable root;
        if (e.getFailingCause() instanceof InvalidTaskParametersException) {
            Button showErrors = new Button(I18nContext.i18n().tr("Show errors"));
            showErrors.setOnAction(event -> StaticStudio.eventStudio().broadcast((Object)new SetActiveContentItemRequest("LOGS")));
            showErrors.getStyleClass().addAll((Object[])Style.BUTTON.css());
            VBox content = new VBox(new Node[]{this.buildLabel(I18nContext.i18n().tr("Input parameters are invalid"), NotificationType.ERROR), showErrors});
            content.getStyleClass().add((Object)"notification-container");
            this.container.addNotification(I18nContext.i18n().tr("Invalid parameters"), (Node)content);
        }
        if ((root = ExceptionUtils.getRootCause((Throwable)e.getFailingCause())) instanceof AccessDeniedException) {
            this.container.addNotification(I18nContext.i18n().tr("Access denied"), (Node)this.buildLabel(I18nContext.i18n().tr("Unable to access \"{0}\", please make sure you have write permissions or open the application messages for details.", new String[]{((AccessDeniedException)root).getFile()}), NotificationType.ERROR));
        }
    }

    @EventListener
    public void onTaskCompleted(TaskExecutionCompletedEvent e) {
        long usages = this.service.getTotalUsages();
        if (usages % 5L == 0L && ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.DONATION_NOTIFICATION)) {
            if (this.random.nextInt() % 2 == 0) {
                this.addDonationNotification(usages);
            } else {
                this.addShareNotification(usages);
            }
        }
    }

    private void addDonationNotification(long usages) {
        VBox content = new VBox(new Node[]{this.buildLabel(I18nContext.i18n().tr("You performed {0} tasks with PDFsam, did it help?", new String[]{Long.toString(usages)}), NotificationType.SUPPORT), UrlButton.styledUrlButton((String)I18nContext.i18n().tr("Give something back"), (String)this.appBrand.property(BrandableProperty.DONATE_URL), null)});
        content.getStyleClass().add((Object)"notification-container");
        this.container.addStickyNotification(I18nContext.i18n().tr("PDFsam worked hard!"), (Node)content);
    }

    private void addShareNotification(long usages) {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        UrlButton bskyButton = UrlButton.styledUrlButton((String)I18nContext.i18n().tr("Spread the word!"), (String)this.appBrand.property(BrandableProperty.BLUESKY_SHARE_URL), null);
        SVGPath bskySvg = new SVGPath();
        bskySvg.setContent("M12 10.8c-1.087-2.114-4.046-6.053-6.798-7.995C2.566.944 1.561 1.266.902 1.565C.139 1.908 0 3.08 0 3.768c0 .69.378 5.65.624 6.479c.815 2.736 3.713 3.66 6.383 3.364q.204-.03.415-.056q-.207.033-.415.056c-3.912.58-7.387 2.005-2.83 7.078c5.013 5.19 6.87-1.113 7.823-4.308c.953 3.195 2.05 9.271 7.733 4.308c4.267-4.308 1.172-6.498-2.74-7.078a9 9 0 0 1-.415-.056q.21.026.415.056c2.67.297 5.568-.628 6.383-3.364c.246-.828.624-5.79.624-6.478c0-.69-.139-1.861-.902-2.206c-.659-.298-1.664-.62-4.3 1.24C16.046 4.748 13.087 8.687 12 10.8");
        bskySvg.getStyleClass().add((Object)"svg-icon");
        bskyButton.setGraphic((Node)bskySvg);
        VBox content = new VBox(new Node[]{this.buildLabel(I18nContext.i18n().tr("You performed {0} tasks with PDFsam, did it help?", new String[]{Long.toString(usages)}), NotificationType.SHARE), new HBox(3.0, new Node[]{spacer, UrlButton.styledUrlButton(null, (String)this.appBrand.property(BrandableProperty.FACEBOOK_SHARE_URL), (Ikon)UniconsLine.FACEBOOK), bskyButton})});
        content.getStyleClass().add((Object)"notification-container");
        this.container.addStickyNotification(I18nContext.i18n().tr("PDFsam worked hard!"), (Node)content);
    }

    @EventListener
    public void onRemoveRequest(RemoveNotificationRequest event) {
        this.container.removeNotification(event.id());
    }

    @EventListener
    public void onUpdateAvailable(UpdateAvailableEvent event) {
        VBox content = new VBox(new Node[]{this.buildLabel(I18nContext.i18n().tr("PDFsam {0} is available for download", new String[]{event.availableVersion()}), NotificationType.INFO), UrlButton.styledUrlButton((String)I18nContext.i18n().tr("Download"), (String)this.appBrand.property(BrandableProperty.DOWNLOAD_URL), null)});
        content.getStyleClass().add((Object)"notification-container");
        this.container.addStickyNotification(I18nContext.i18n().tr("New version available"), (Node)content);
    }

    @EventListener
    public void onNoUpdateAvailable(NoUpdateAvailable event) {
        VBox content = new VBox(new Node[]{this.buildLabel(I18nContext.i18n().tr("You are running the latest version of PDFsam Basic"), NotificationType.INFO)});
        content.getStyleClass().add((Object)"notification-container");
        this.container.addNotification(I18nContext.i18n().tr("No update"), (Node)content);
    }

    @EventListener
    public void onNewImportantNews(NewImportantNewsEvent event) {
        VBox content = new VBox(new Node[]{this.buildLabel(event.news().content(), null), UrlButton.styledUrlButton((String)I18nContext.i18n().tr("Open"), (String)event.news().link(), (Ikon)UniconsLine.EXTERNAL_LINK_ALT)});
        content.getStyleClass().add((Object)"notification-container");
        this.container.addStickyNotification(event.news().title(), (Node)content);
    }
}

